/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterRequest
implements Serializable {
    private String _beanIdentifier;
    private ClusterMessageType _clusterMessageType;
    private boolean _fireAndForget;
    private MethodHandler _methodHandler;
    private boolean _multicast;
    private ClusterNode _originatingClusterNode;
    private boolean _parallelized;
    private String _servletContextName;
    private boolean _skipLocal;
    private Set<Address> _targetClusterNodeAddresses;
    private Set<String> _targetClusterNodeIds;
    private String _uuid;

    public static ClusterRequest createClusterNotifyRequest(ClusterNode originatingClusterNode) {
        ClusterRequest clusterRequest = new ClusterRequest();
        clusterRequest.setClusterMessageType(ClusterMessageType.NOTIFY);
        clusterRequest.setMulticast(true);
        clusterRequest.setOriginatingClusterNode(originatingClusterNode);
        clusterRequest.setParallelized(true);
        clusterRequest.setSkipLocal(true);
        clusterRequest.setUuid(PortalUUIDUtil.generate());
        return clusterRequest;
    }

    public static ClusterRequest createMulticastRequest(MethodHandler methodHandler) {
        return ClusterRequest.createMulticastRequest(methodHandler, false);
    }

    public static ClusterRequest createMulticastRequest(MethodHandler methodHandler, boolean skipLocal) {
        ClusterRequest clusterRequest = new ClusterRequest();
        clusterRequest.setClusterMessageType(ClusterMessageType.EXECUTE);
        clusterRequest.setMethodHandler(methodHandler);
        clusterRequest.setMulticast(true);
        clusterRequest.setSkipLocal(skipLocal);
        clusterRequest.setUuid(PortalUUIDUtil.generate());
        return clusterRequest;
    }

    public static ClusterRequest createUnicastRequest(MethodHandler methodHandler, Address ... targetClusterNodeAddresses) {
        ClusterRequest clusterRequest = new ClusterRequest();
        clusterRequest.addTargetClusterNodeAddresses(targetClusterNodeAddresses);
        clusterRequest.setClusterMessageType(ClusterMessageType.EXECUTE);
        clusterRequest.setMethodHandler(methodHandler);
        clusterRequest.setMulticast(false);
        clusterRequest.setSkipLocal(false);
        clusterRequest.setUuid(PortalUUIDUtil.generate());
        return clusterRequest;
    }

    public static ClusterRequest createUnicastRequest(MethodHandler methodHandler, String ... targetClusterNodeIds) {
        ClusterRequest clusterRequest = new ClusterRequest();
        clusterRequest.addTargetClusterNodeIds(targetClusterNodeIds);
        clusterRequest.setClusterMessageType(ClusterMessageType.EXECUTE);
        clusterRequest.setMethodHandler(methodHandler);
        clusterRequest.setMulticast(false);
        clusterRequest.setSkipLocal(false);
        clusterRequest.setUuid(PortalUUIDUtil.generate());
        return clusterRequest;
    }

    public void addTargetClusterNodeAddresses(Address ... targetClusterNodeAddresses) {
        if (this._targetClusterNodeAddresses == null) {
            this._targetClusterNodeAddresses = new HashSet<Address>(targetClusterNodeAddresses.length);
        }
        Address[] addressArray = targetClusterNodeAddresses;
        int n = targetClusterNodeAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            Address targetClusterNodeAddress = addressArray[n2];
            this._targetClusterNodeAddresses.add(targetClusterNodeAddress);
            ++n2;
        }
    }

    public void addTargetClusterNodeIds(String ... targetClusterNodeIds) {
        if (this._targetClusterNodeIds == null) {
            this._targetClusterNodeIds = new HashSet<String>(targetClusterNodeIds.length);
        }
        String[] stringArray = targetClusterNodeIds;
        int n = targetClusterNodeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String targetClusterNodeId = stringArray[n2];
            this._targetClusterNodeIds.add(targetClusterNodeId);
            ++n2;
        }
    }

    public String getBeanIdentifier() {
        return this._beanIdentifier;
    }

    public ClusterMessageType getClusterMessageType() {
        return this._clusterMessageType;
    }

    public MethodHandler getMethodHandler() {
        return this._methodHandler;
    }

    public ClusterNode getOriginatingClusterNode() {
        return this._originatingClusterNode;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public Collection<Address> getTargetClusterNodeAddresses() {
        return this._targetClusterNodeAddresses;
    }

    public Collection<String> getTargetClusterNodeIds() {
        return this._targetClusterNodeIds;
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean isFireAndForget() {
        return this._fireAndForget;
    }

    public boolean isMulticast() {
        return this._multicast;
    }

    public boolean isParallelized() {
        return this._parallelized;
    }

    public boolean isSkipLocal() {
        return this._skipLocal;
    }

    public void setBeanIdentifier(String beanIdentifier) {
        this._beanIdentifier = beanIdentifier;
    }

    public void setClusterMessageType(ClusterMessageType clusterMessageType) {
        this._clusterMessageType = clusterMessageType;
    }

    public void setFireAndForget(boolean fireAndForget) {
        this._fireAndForget = fireAndForget;
    }

    public void setMethodHandler(MethodHandler methodHandler) {
        this._methodHandler = methodHandler;
    }

    public void setMulticast(boolean multicast) {
        this._multicast = multicast;
    }

    public void setOriginatingClusterNode(ClusterNode originatingClusterNode) {
        this._originatingClusterNode = originatingClusterNode;
    }

    public void setParallelized(boolean parallelized) {
        this._parallelized = parallelized;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
    }

    public void setSkipLocal(boolean skipLocal) {
        this._skipLocal = skipLocal;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public String toString() {
        StringBundler sb = new StringBundler(17);
        sb.append("{clusterMessageType=");
        sb.append((Object)this._clusterMessageType);
        sb.append(", methodHandler=");
        sb.append(this._methodHandler);
        sb.append(", multicast=");
        sb.append(this._multicast);
        if (this._clusterMessageType.equals((Object)ClusterMessageType.NOTIFY)) {
            sb.append(", originatingClusterNode=");
            sb.append(this._originatingClusterNode);
        }
        sb.append(", servletContextName=");
        sb.append(this._servletContextName);
        sb.append(", parallelized=");
        sb.append(this._parallelized);
        sb.append(", skipLocal=");
        sb.append(this._skipLocal);
        sb.append(", uuid=");
        sb.append(this._uuid);
        sb.append("}");
        return sb.toString();
    }

    private ClusterRequest() {
    }
}

