/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.shard;

import com.liferay.portal.kernel.dao.shard.Shard;
import javax.sql.DataSource;

public class ShardUtil {
    private static final String[] _DEFAULT_SHARD_ARRAY = new String[0];
    private static Shard _shard;

    public static String[] getAvailableShardNames() {
        String[] availableShardNames;
        if (_shard != null && (availableShardNames = _shard.getAvailableShardNames()) != null) {
            return availableShardNames;
        }
        return _DEFAULT_SHARD_ARRAY;
    }

    public static String getCurrentShardName() {
        if (_shard != null) {
            return _shard.getCurrentShardName();
        }
        return "";
    }

    public static DataSource getDataSource() {
        if (_shard != null) {
            return _shard.getDataSource();
        }
        return null;
    }

    public static String getDefaultShardName() {
        if (_shard != null) {
            return _shard.getDefaultShardName();
        }
        return null;
    }

    public static boolean isEnabled() {
        if (_shard != null) {
            return _shard.isEnabled();
        }
        return false;
    }

    public static String popCompanyService() {
        String value = null;
        if (_shard != null) {
            value = _shard.popCompanyService();
        }
        return value;
    }

    public static void pushCompanyService(long companyId) {
        if (_shard != null) {
            _shard.pushCompanyService(companyId);
        }
    }

    public static void pushCompanyService(String shardName) {
        if (_shard != null) {
            _shard.pushCompanyService(shardName);
        }
    }

    public void setShard(Shard shard) {
        _shard = shard;
    }
}

