/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.io.unsync.UnsyncFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnsyncBufferedInputStream
extends UnsyncFilterInputStream {
    protected byte[] buffer;
    protected int firstInvalidIndex;
    protected int index;
    protected int markLimitIndex = -1;
    private static int _DEFAULT_BUFFER_SIZE = 8192;

    public UnsyncBufferedInputStream(InputStream inputStream) {
        this(inputStream, _DEFAULT_BUFFER_SIZE);
    }

    public UnsyncBufferedInputStream(InputStream inputStream, int size) {
        super(inputStream);
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 0");
        }
        this.buffer = new byte[size];
    }

    public int available() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        return this.inputStream.available() + (this.firstInvalidIndex - this.index);
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
            this.buffer = null;
        }
    }

    public void mark(int readLimit) {
        if (readLimit <= 0) {
            return;
        }
        this.markLimitIndex = readLimit;
        if (this.index > 0) {
            int available = this.firstInvalidIndex - this.index;
            if (available > 0) {
                System.arraycopy(this.buffer, this.index, this.buffer, 0, available);
                this.index = 0;
                this.firstInvalidIndex = available;
            } else {
                this.firstInvalidIndex = 0;
                this.index = 0;
            }
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (this.index >= this.firstInvalidIndex) {
            this.fillInBuffer();
            if (this.index >= this.firstInvalidIndex) {
                return -1;
            }
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int currentRead;
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (length <= 0) {
            return 0;
        }
        int read = 0;
        do {
            if ((currentRead = this.readOnce(bytes, offset + read, length - read)) > 0) continue;
            if (read != 0) break;
            read = currentRead;
            break;
        } while ((read += currentRead) < length && this.inputStream.available() > 0);
        return read;
    }

    public void reset() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (this.markLimitIndex < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.index = 0;
    }

    public long skip(long skip) throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (skip <= 0L) {
            return 0L;
        }
        long available = this.firstInvalidIndex - this.index;
        if (available <= 0L) {
            if (this.markLimitIndex < 0) {
                return this.inputStream.skip(skip);
            }
            this.fillInBuffer();
            available = this.firstInvalidIndex - this.index;
            if (available <= 0L) {
                return 0L;
            }
        }
        if (available < skip) {
            skip = available;
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }

    protected void fillInBuffer() throws IOException {
        if (this.markLimitIndex < 0) {
            this.firstInvalidIndex = 0;
            this.index = 0;
            int number = this.inputStream.read(this.buffer);
            if (number > 0) {
                this.firstInvalidIndex = number;
            }
            return;
        }
        if (this.index >= this.markLimitIndex) {
            this.markLimitIndex = -1;
            this.firstInvalidIndex = 0;
            this.index = 0;
        } else if (this.index == this.buffer.length) {
            int newBufferSize = this.buffer.length * 2;
            if (newBufferSize > this.markLimitIndex) {
                newBufferSize = this.markLimitIndex;
            }
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.firstInvalidIndex = this.index;
        int number = this.inputStream.read(this.buffer, this.index, this.buffer.length - this.index);
        if (number > 0) {
            this.firstInvalidIndex += number;
        }
    }

    protected int readOnce(byte[] bytes, int offset, int length) throws IOException {
        int available = this.firstInvalidIndex - this.index;
        if (available <= 0) {
            if (this.markLimitIndex < 0 && length >= this.buffer.length) {
                return this.inputStream.read(bytes, offset, length);
            }
            this.fillInBuffer();
            available = this.firstInvalidIndex - this.index;
            if (available <= 0) {
                return -1;
            }
        }
        if (length > available) {
            length = available;
        }
        System.arraycopy(this.buffer, this.index, bytes, offset, length);
        this.index += length;
        return length;
    }
}

