/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import java.io.Writer;

public class UnsyncStringWriter
extends Writer {
    protected StringBuilder stringBuilder;
    protected StringBundler stringBundler;

    public UnsyncStringWriter() {
        this(true);
    }

    public UnsyncStringWriter(boolean useStringBundler) {
        if (useStringBundler) {
            this.stringBundler = new StringBundler();
        } else {
            this.stringBuilder = new StringBuilder();
        }
    }

    public UnsyncStringWriter(boolean useStringBundler, int initialCapacity) {
        if (useStringBundler) {
            this.stringBundler = new StringBundler(initialCapacity);
        } else {
            this.stringBuilder = new StringBuilder(initialCapacity);
        }
    }

    public UnsyncStringWriter(int initialCapacity) {
        this(true, initialCapacity);
    }

    public UnsyncStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public UnsyncStringWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    public UnsyncStringWriter append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.write(charSequence.subSequence(start, end).toString());
        return this;
    }

    public void close() {
    }

    public void flush() {
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public StringBundler getStringBundler() {
        return this.stringBundler;
    }

    public void reset() {
        if (this.stringBundler != null) {
            this.stringBundler.setIndex(0);
        } else {
            this.stringBuilder.setLength(0);
        }
    }

    public String toString() {
        if (this.stringBundler != null) {
            return this.stringBundler.toString();
        }
        return this.stringBuilder.toString();
    }

    public void write(char[] chars, int offset, int length) {
        if (length <= 0) {
            return;
        }
        if (this.stringBundler != null) {
            this.stringBundler.append(new String(chars, offset, length));
        } else {
            this.stringBuilder.append(chars, offset, length);
        }
    }

    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    public void write(int c) {
        if (this.stringBundler != null) {
            char ch = (char)c;
            if (ch <= '\u007f') {
                this.stringBundler.append(StringPool.ASCII_TABLE[ch]);
            } else {
                this.stringBundler.append(String.valueOf(ch));
            }
        } else {
            this.stringBuilder.append((char)c);
        }
    }

    public void write(String string) {
        if (this.stringBundler != null) {
            this.stringBundler.append(string);
        } else {
            this.stringBuilder.append(string);
        }
    }

    public void write(String string, int offset, int length) {
        if (string == null || offset == 0 && length == string.length()) {
            this.write(string);
        } else if (this.stringBundler != null) {
            this.stringBundler.append(string.substring(offset, offset + length));
        } else {
            this.stringBuilder.append(string.substring(offset, offset + length));
        }
    }
}

