/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jndi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

public class JNDIUtil {
    private static Log _log = LogFactoryUtil.getLog(JNDIUtil.class);
    private static Map<String, Object> _cache = new HashMap<String, Object>();

    public static Object lookup(Context ctx, String location) throws NamingException {
        return JNDIUtil.lookup(ctx, location, false);
    }

    public static Object lookup(Context ctx, String location, boolean cache) throws NamingException {
        Object obj = null;
        if (cache) {
            obj = _cache.get(location);
            if (obj == null) {
                obj = JNDIUtil._lookup(ctx, location);
                _cache.put(location, obj);
            }
        } else {
            obj = JNDIUtil._lookup(ctx, location);
        }
        return obj;
    }

    private static Object _lookup(Context ctx, String location) throws NamingException {
        if (_log.isDebugEnabled()) {
            _log.debug("Lookup " + location);
        }
        Object obj = null;
        try {
            obj = ctx.lookup(location);
        }
        catch (NamingException n1) {
            if (location.indexOf("java:comp/env/") != -1) {
                try {
                    String newLocation = StringUtil.replace(location, "java:comp/env/", "");
                    if (_log.isDebugEnabled()) {
                        _log.debug(n1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = ctx.lookup(newLocation);
                }
                catch (NamingException n2) {
                    String newLocation = StringUtil.replace(location, "comp/env/", "");
                    if (_log.isDebugEnabled()) {
                        _log.debug(n2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = ctx.lookup(newLocation);
                }
            }
            if (location.indexOf("java:") != -1) {
                try {
                    String newLocation = StringUtil.replace(location, "java:", "");
                    if (_log.isDebugEnabled()) {
                        _log.debug(n1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = ctx.lookup(newLocation);
                }
                catch (NamingException n2) {
                    String newLocation = StringUtil.replace(location, "java:", "java:comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(n2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = ctx.lookup(newLocation);
                }
            }
            if (location.indexOf("java:") == -1) {
                try {
                    String newLocation = "java:" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(n1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = ctx.lookup(newLocation);
                }
                catch (NamingException n2) {
                    String newLocation = "java:comp/env/" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(n2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = ctx.lookup(newLocation);
                }
            }
            throw new NamingException();
        }
        return obj;
    }
}

