/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.memory;

import com.liferay.portal.kernel.memory.EqualityWeakReference;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinalizeManager {
    public static final boolean THREAD_ENABLED = GetterUtil.getBoolean(PropsUtil.get("finalize.manager.thread.enabled"));
    private static Map<Reference<?>, FinalizeAction> _referenceActionMap = new ConcurrentHashMap();
    private static ReferenceQueue<Object> _referenceQueue = new ReferenceQueue();

    static {
        if (THREAD_ENABLED) {
            FinalizeThread thread = new FinalizeThread("Finalize Thread");
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static <T> Reference<T> register(T realReference, FinalizeAction finalizeAction) {
        EqualityWeakReference<Object> reference = new EqualityWeakReference<Object>(realReference, _referenceQueue);
        _referenceActionMap.put(reference, finalizeAction);
        if (!THREAD_ENABLED) {
            FinalizeManager._pollingCleanup();
        }
        return reference;
    }

    private static void _pollingCleanup() {
        Reference<Object> reference = null;
        while ((reference = _referenceQueue.poll()) != null) {
            FinalizeAction finalizeAction = _referenceActionMap.remove(reference);
            finalizeAction.doFinalize();
        }
    }

    private static class FinalizeThread
    extends Thread {
        public FinalizeThread(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference reference = _referenceQueue.remove();
                        FinalizeAction finalizeAction = (FinalizeAction)_referenceActionMap.remove(reference);
                        finalizeAction.doFinalize();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

