/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelDestination
extends BaseAsyncDestination {
    private static Log _log = LogFactoryUtil.getLog(ParallelDestination.class);

    public ParallelDestination() {
    }

    public ParallelDestination(String name) {
        super(name);
    }

    public ParallelDestination(String name, int workersCoreSize, int workersMaxSize) {
        super(name, workersCoreSize, workersMaxSize);
    }

    @Override
    protected void dispatch(Set<MessageListener> messageListeners, final Message message) {
        if (!message.contains("companyId")) {
            message.put("companyId", CompanyThreadLocal.getCompanyId());
        }
        if (!message.contains("principalName")) {
            message.put("principalName", PrincipalThreadLocal.getName());
        }
        if (!message.contains("principalPassword")) {
            message.put("principalPassword", PrincipalThreadLocal.getPassword());
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        for (final MessageListener messageListener : messageListeners) {
            MessageRunnable runnable = new MessageRunnable(message){

                public void run() {
                    long companyId = CompanyThreadLocal.getCompanyId();
                    String principalName = PrincipalThreadLocal.getName();
                    String principalPassword = PrincipalThreadLocal.getPassword();
                    try {
                        try {
                            String messagePrincipalPassword;
                            String messagePrincipalName;
                            long messageCompanyId = message.getLong("companyId");
                            if (messageCompanyId > 0L) {
                                CompanyThreadLocal.setCompanyId(messageCompanyId);
                            }
                            if (Validator.isNotNull(messagePrincipalName = message.getString("principalName"))) {
                                PrincipalThreadLocal.setName(messagePrincipalName);
                            }
                            if (Validator.isNotNull(messagePrincipalPassword = message.getString("principalPassword"))) {
                                PrincipalThreadLocal.setPassword(messagePrincipalPassword);
                            }
                            messageListener.receive(message);
                        }
                        catch (MessageListenerException mle) {
                            _log.error("Unable to process message " + message, mle);
                            CompanyThreadLocal.setCompanyId(companyId);
                            PrincipalThreadLocal.setName(principalName);
                            PrincipalThreadLocal.setPassword(principalPassword);
                            CentralizedThreadLocal.clearShortLivedThreadLocals();
                        }
                    }
                    finally {
                        CompanyThreadLocal.setCompanyId(companyId);
                        PrincipalThreadLocal.setName(principalName);
                        PrincipalThreadLocal.setPassword(principalPassword);
                        CentralizedThreadLocal.clearShortLivedThreadLocals();
                    }
                }
            };
            threadPoolExecutor.execute(runnable);
        }
    }
}

