/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialDestination
extends BaseAsyncDestination {
    private static final int _WORKERS_CORE_SIZE = 1;
    private static final int _WORKERS_MAX_SIZE = 1;
    private static Log _log = LogFactoryUtil.getLog(SerialDestination.class);

    public SerialDestination() {
        this.setWorkersCoreSize(1);
        this.setWorkersMaxSize(1);
    }

    public SerialDestination(String name) {
        super(name, 1, 1);
    }

    @Override
    protected void dispatch(final Set<MessageListener> messageListeners, final Message message) {
        if (!message.contains("companyId")) {
            message.put("companyId", CompanyThreadLocal.getCompanyId());
        }
        if (!message.contains("principalName")) {
            message.put("principalName", PrincipalThreadLocal.getName());
        }
        if (!message.contains("principalPassword")) {
            message.put("principalPassword", PrincipalThreadLocal.getPassword());
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        MessageRunnable runnable = new MessageRunnable(message){

            public void run() {
                long companyId = CompanyThreadLocal.getCompanyId();
                String principalName = PrincipalThreadLocal.getName();
                String principalPassword = PrincipalThreadLocal.getPassword();
                try {
                    String messagePrincipalPassword;
                    String messagePrincipalName;
                    long messageCompanyId = message.getLong("companyId");
                    if (messageCompanyId > 0L) {
                        CompanyThreadLocal.setCompanyId(messageCompanyId);
                    }
                    if (Validator.isNotNull(messagePrincipalName = message.getString("principalName"))) {
                        PrincipalThreadLocal.setName(messagePrincipalName);
                    }
                    if (Validator.isNotNull(messagePrincipalPassword = message.getString("principalPassword"))) {
                        PrincipalThreadLocal.setPassword(messagePrincipalPassword);
                    }
                    for (MessageListener messageListener : messageListeners) {
                        try {
                            messageListener.receive(message);
                        }
                        catch (MessageListenerException mle) {
                            _log.error("Unable to process message " + message, mle);
                        }
                    }
                }
                finally {
                    CompanyThreadLocal.setCompanyId(companyId);
                    PrincipalThreadLocal.setName(principalName);
                    PrincipalThreadLocal.setPassword(principalPassword);
                    CentralizedThreadLocal.clearShortLivedThreadLocals();
                }
            }
        };
        threadPoolExecutor.execute(runnable);
    }
}

