/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import java.util.concurrent.atomic.AtomicLong;

public class SynchronousDestination
extends BaseDestination {
    private static Log _log = LogFactoryUtil.getLog(SynchronousDestination.class);
    private AtomicLong _sentMessageCounter = new AtomicLong();

    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setSentMessageCount(this._sentMessageCounter.get());
        return destinationStatistics;
    }

    public void send(Message message) {
        for (MessageListener messageListener : this.messageListeners) {
            try {
                messageListener.receive(message);
            }
            catch (MessageListenerException mle) {
                _log.error("Unable to process message " + message, mle);
            }
        }
        this._sentMessageCounter.incrementAndGet();
    }
}

