/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.sender;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import java.util.Set;

public class DirectSynchronousMessageSender
implements SynchronousMessageSender {
    private static Log _log = LogFactoryUtil.getLog(DirectSynchronousMessageSender.class);
    private MessageBus _messageBus;

    public Object send(String destinationName, Message message) throws MessageBusException {
        Destination destination = this._messageBus.getDestination(destinationName);
        if (destination == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Destination " + destinationName + " is not configured");
            }
            return null;
        }
        if (destination.getMessageListenerCount() == 0) {
            if (_log.isInfoEnabled()) {
                _log.info("Destination " + destinationName + " does not have any message listeners");
            }
            return null;
        }
        if (destination instanceof SynchronousDestination) {
            destination.send(message);
        } else {
            Set<MessageListener> messageListeners = destination.getMessageListeners();
            for (MessageListener messageListener : messageListeners) {
                try {
                    messageListener.receive(message);
                }
                catch (MessageListenerException mle) {
                    throw new MessageBusException(mle);
                }
            }
        }
        return message.getResponse();
    }

    public Object send(String destinationName, Message message, long timeout) throws MessageBusException {
        if (_log.isWarnEnabled()) {
            _log.warn(String.valueOf(DirectSynchronousMessageSender.class.getName()) + " does not support timeout");
        }
        return this.send(destinationName, message);
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }
}

