/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.monitoring.statistics;

import com.liferay.portal.kernel.monitoring.statistics.AverageStatistics;
import com.liferay.portal.kernel.monitoring.statistics.CountStatistics;
import com.liferay.portal.kernel.monitoring.statistics.Statistics;

public class RequestStatistics
implements Statistics {
    private String _description;
    private CountStatistics _errorStatistics;
    private String _name;
    private AverageStatistics _successStatistics;
    private CountStatistics _timeoutStatistics;

    public RequestStatistics(String name) {
        this._name = name;
        this._errorStatistics = new CountStatistics(name);
        this._successStatistics = new AverageStatistics(name);
        this._timeoutStatistics = new CountStatistics(name);
    }

    public long getAverageTime() {
        return this._successStatistics.getAverageTime();
    }

    public String getDescription() {
        return this._description;
    }

    public long getErrorCount() {
        return this._errorStatistics.getCount();
    }

    public long getMaxTime() {
        return this._successStatistics.getMaxTime();
    }

    public long getMinTime() {
        return this._successStatistics.getMinTime();
    }

    public String getName() {
        return this._name;
    }

    public long getRequestCount() {
        return this.getErrorCount() + this.getSuccessCount() + this.getTimeoutCount();
    }

    public long getSuccessCount() {
        return this._successStatistics.getCount();
    }

    public long getTimeoutCount() {
        return this._timeoutStatistics.getCount();
    }

    public void incrementError() {
        this._errorStatistics.incrementCount();
    }

    public void incrementSuccessDuration(long duration) {
        this._successStatistics.addDuration(duration);
    }

    public void incrementTimeout() {
        this._timeoutStatistics.incrementCount();
    }

    public void reset() {
        this._errorStatistics.reset();
        this._successStatistics.reset();
        this._timeoutStatistics.reset();
    }

    public void setDescription(String description) {
        this._description = description;
    }
}

