/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ClassPathUtil {
    private static Log _log = LogFactoryUtil.getLog(ClassPathUtil.class);
    private static String _globalClassPath;
    private static String _portalClassPath;

    public static String getGlobalClassPath() {
        return _globalClassPath;
    }

    public static String getPortalClassPath() {
        return _portalClassPath;
    }

    public static void initializeClassPaths(ServletContext servletContext) {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (classLoader == null) {
            _log.error("Portal ClassLoader is null");
            return;
        }
        StringBundler sb = new StringBundler(7);
        String appServerGlobalClassPath = ClassPathUtil._buildClassPath(classLoader, ServletException.class.getName());
        sb.append(appServerGlobalClassPath);
        sb.append(File.pathSeparator);
        String portalGlobalClassPath = ClassPathUtil._buildClassPath(classLoader, PortalException.class.getName());
        sb.append(portalGlobalClassPath);
        _globalClassPath = sb.toString();
        sb.append(File.pathSeparator);
        sb.append(ClassPathUtil._buildClassPath(classLoader, "com.liferay.portal.servlet.MainServlet"));
        sb.append(File.pathSeparator);
        sb.append(servletContext.getRealPath("").concat("/WEB-INF/classes"));
        _portalClassPath = sb.toString();
    }

    private static String _buildClassPath(ClassLoader classloader, String className) {
        String protocol;
        String pathOfClass = StringUtil.replace(className, '.', '/');
        pathOfClass = pathOfClass.concat(".class");
        URL url = classloader.getResource(pathOfClass);
        if (_log.isDebugEnabled()) {
            _log.debug("Build class path from " + url);
        }
        if ((protocol = url.getProtocol()).equals("bundle") || protocol.equals("bundleresource")) {
            try {
                URLConnection urlConnection = url.openConnection();
                Class<?> clazz = urlConnection.getClass();
                Method getLocalURLMethod = clazz.getDeclaredMethod("getLocalURL", new Class[0]);
                getLocalURLMethod.setAccessible(true);
                url = (URL)getLocalURLMethod.invoke((Object)urlConnection, new Object[0]);
            }
            catch (Exception e) {
                _log.error("Unable to resolve local URL from bundle", e);
                return "";
            }
        }
        String path = URLCodec.decodeURL(url.getPath());
        if (ServerDetector.isWebLogic() && protocol.equals("zip")) {
            path = "file:".concat(path);
        }
        if (ServerDetector.isJBoss()) {
            path = StringUtil.replace(path, '\\', '/');
            if (protocol.equals("vfs")) {
                String jarFilePath;
                File jarFile;
                int pos = path.indexOf(".jar/");
                if (pos != -1 && (jarFile = new File(jarFilePath = path.substring(0, pos + 4))).isFile()) {
                    path = String.valueOf(jarFilePath) + '!' + path.substring(pos + 4);
                }
                path = "file:".concat(path);
            }
        }
        File dir = null;
        int pos = -1;
        if (!path.startsWith("file:") || (pos = path.indexOf(33)) == -1) {
            if (!path.endsWith(pathOfClass)) {
                _log.error("Class " + className + " is not loaded from a JAR file");
                return "";
            }
            String classesDirName = path.substring(0, path.length() - pathOfClass.length());
            if (!classesDirName.endsWith("/WEB-INF/classes/")) {
                _log.error("Class " + className + " is not loaded from a standard " + "location (/WEB-INF/classes)");
                return "";
            }
            String libDirName = classesDirName.substring(0, classesDirName.length() - "classes/".length());
            libDirName = String.valueOf(libDirName) + "/lib";
            dir = new File(libDirName);
        } else {
            pos = path.lastIndexOf(47, pos);
            dir = new File(path.substring("file:".length(), pos));
        }
        if (!dir.isDirectory()) {
            _log.error(String.valueOf(dir.toString()) + " is not a directory");
            return "";
        }
        File[] files = dir.listFiles();
        StringBundler sb = new StringBundler(files.length * 2);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            sb.append(file.getAbsolutePath());
            sb.append(File.pathSeparator);
            ++n2;
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

