/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.MessagingProxy;
import com.liferay.portal.kernel.messaging.proxy.ProxyMode;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SchedulerEngine {
    public static final String CONTEXT_PATH = "CONTEXT_PATH";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final int DESCRIPTION_MAX_LENGTH = GetterUtil.getInteger(PropsUtil.get("scheduler.description.max.length"));
    public static final String DESTINATION_NAME = "DESTINATION_NAME";
    public static final String DISABLE = "DISABLE";
    public static final String END_TIME = "END_TIME";
    public static final String EXCEPTIONS_MAX_SIZE = "EXCEPTIONS_MAX_SIZE";
    public static final String FINAL_FIRE_TIME = "FINAL_FIRE_TIME";
    public static final int GROUP_NAME_MAX_LENGTH = GetterUtil.getInteger(PropsUtil.get("scheduler.group.name.max.length"));
    public static final int JOB_NAME_MAX_LENGTH = GetterUtil.getInteger(PropsUtil.get("scheduler.job.name.max.length"));
    public static final String JOB_STATE = "JOB_STATE";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String MESSAGE = "MESSAGE";
    public static final String MESSAGE_LISTENER_UUID = "MESSAGE_LISTENER_UUID";
    public static final String NEXT_FIRE_TIME = "NEXT_FIRE_TIME";
    public static final String PREVIOUS_FIRE_TIME = "PREVIOUS_FIRE_TIME";
    public static final String RECEIVER_KEY = "RECEIVER_KEY";
    public static final String SCRIPT = "SCRIPT";
    public static final String START_TIME = "START_TIME";
    public static final String STORAGE_TYPE = "STORAGE_TYPE";

    public void delete(String var1) throws SchedulerException;

    public void delete(String var1, String var2) throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public SchedulerResponse getScheduledJob(String var1, String var2) throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public List<SchedulerResponse> getScheduledJobs(String var1) throws SchedulerException;

    public void pause(String var1) throws SchedulerException;

    public void pause(String var1, String var2) throws SchedulerException;

    public void resume(String var1) throws SchedulerException;

    public void resume(String var1, String var2) throws SchedulerException;

    public void schedule(Trigger var1, String var2, String var3, Message var4) throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public void shutdown() throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public void start() throws SchedulerException;

    public void suppressError(String var1, String var2) throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public void unschedule(String var1) throws SchedulerException;

    @MessagingProxy(mode=ProxyMode.SYNC)
    public void unschedule(String var1, String var2) throws SchedulerException;

    public void update(Trigger var1) throws SchedulerException;
}

