/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineClusterManager;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.SchedulerLifecycle;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerEngineUtil {
    private static Log _log = LogFactoryUtil.getLog(SchedulerEngineUtil.class);
    private static SchedulerEngineUtil _instance = new SchedulerEngineUtil();
    private SchedulerEngine _schedulerEngine;
    private SchedulerEngineClusterManager _schedulerEngineClusterManager;

    public static void addScriptingJob(Trigger trigger, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        _instance._addScriptingJob(trigger, storageType, description, language, script, exceptionsMaxSize);
    }

    public static void delete(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        _instance._delete(schedulerEntry, storageType);
    }

    public static void delete(String groupName, StorageType storageType) throws SchedulerException {
        _instance._delete(groupName, storageType);
    }

    public static void delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        _instance._delete(jobName, groupName, storageType);
    }

    public static Date getEndTime(SchedulerResponse schedulerResponse) {
        return _instance._getEndTime(schedulerResponse);
    }

    public static Date getEndTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getEndTime(jobName, groupName, storageType);
    }

    public static Date getFinalFireTime(SchedulerResponse schedulerResponse) {
        return _instance._getFinalFireTime(schedulerResponse);
    }

    public static Date getFinalFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getFinalFireTime(jobName, groupName, storageType);
    }

    public static ObjectValuePair<Exception, Date>[] getJobExceptions(SchedulerResponse schedulerResponse) {
        return _instance._getJobExceptions(schedulerResponse);
    }

    public static ObjectValuePair<Exception, Date>[] getJobExceptions(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getJobExceptions(jobName, groupName, storageType);
    }

    public static TriggerState getJobState(SchedulerResponse schedulerResponse) {
        return _instance._getJobState(schedulerResponse);
    }

    public static TriggerState getJobState(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getJobState(jobName, groupName, storageType);
    }

    public static Date getNextFireTime(SchedulerResponse schedulerResponse) {
        return _instance._getNextFireTime(schedulerResponse);
    }

    public static Date getNextFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getNextFireTime(jobName, groupName, storageType);
    }

    public static Date getPreviousFireTime(SchedulerResponse schedulerResponse) {
        return _instance._getPreviousFireTime(schedulerResponse);
    }

    public static Date getPreviousFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getPreviousFireTime(jobName, groupName, storageType);
    }

    public static SchedulerResponse getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getScheduledJob(jobName, groupName, storageType);
    }

    public static List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        return _instance._getScheduledJobs();
    }

    public static List<SchedulerResponse> getScheduledJobs(StorageType storageType) throws SchedulerException {
        return _instance._getScheduledJobs(storageType);
    }

    public static List<SchedulerResponse> getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getScheduledJobs(groupName, storageType);
    }

    public static Date getStartTime(SchedulerResponse schedulerResponse) {
        return _instance._getStartTime(schedulerResponse);
    }

    public static Date getStartTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return _instance._getStartTime(jobName, groupName, storageType);
    }

    public static void initialize() throws SchedulerException {
        _instance._initialize();
        SchedulerLifecycle schedulerLifecycle = new SchedulerLifecycle();
        schedulerLifecycle.registerPortalLifecycle(2);
    }

    public static String namespaceGroupName(String groupName, StorageType storageType) {
        return _instance._namespaceGroupName(groupName, storageType);
    }

    public static void pause(String groupName, StorageType storageType) throws SchedulerException {
        _instance._pause(groupName, storageType);
    }

    public static void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        _instance._pause(jobName, groupName, storageType);
    }

    public static void resume(String groupName, StorageType storageType) throws SchedulerException {
        _instance._resume(groupName, storageType);
    }

    public static void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        _instance._resume(jobName, groupName, storageType);
    }

    public static void schedule(SchedulerEntry schedulerEntry, StorageType storageType, ClassLoader classLoader, int exceptionsMaxSize) throws SchedulerException {
        _instance._schedule(schedulerEntry, storageType, classLoader, exceptionsMaxSize);
    }

    public static void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Message message, int exceptionsMaxSize) throws SchedulerException {
        _instance._schedule(trigger, storageType, description, destinationName, message, exceptionsMaxSize);
    }

    public static void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Object payload, int exceptionsMaxSize) throws SchedulerException {
        _instance._schedule(trigger, storageType, description, destinationName, payload, exceptionsMaxSize);
    }

    public static void shutdown() throws SchedulerException {
        _instance._shutdown();
    }

    public static void start() throws SchedulerException {
        _instance._start();
    }

    public static void suppressError(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        _instance._suppressError(jobName, groupName, storageType);
    }

    public static void unschedule(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        _instance._unschedule(schedulerEntry, storageType);
    }

    public static void unschedule(String groupName, StorageType storageType) throws SchedulerException {
        _instance._unschedule(groupName, storageType);
    }

    public static void unschedule(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        _instance._unschedule(jobName, groupName, storageType);
    }

    public static void update(String jobName, String groupName, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        _instance._update(jobName, groupName, storageType, description, language, script, exceptionsMaxSize);
    }

    public static void update(Trigger trigger, StorageType storageType) throws SchedulerException {
        _instance._update(trigger, storageType);
    }

    public static void updateMemorySchedulerClusterMaster() throws SchedulerException {
        _instance._updateMemorySchedulerClusterMaster();
    }

    public void setSchedulerEngine(SchedulerEngine schedulerEngine) {
        SchedulerEngineUtil._instance._schedulerEngine = schedulerEngine;
        if (schedulerEngine instanceof SchedulerEngineClusterManager) {
            SchedulerEngineUtil._instance._schedulerEngineClusterManager = (SchedulerEngineClusterManager)((Object)schedulerEngine);
        }
    }

    private void _addScriptingJob(Trigger trigger, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.put("LANGUAGE", language);
        message.put("SCRIPT", script);
        this._schedule(trigger, storageType, description, "liferay/scheduler_scripting", message, exceptionsMaxSize);
    }

    private void _delete(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        Trigger trigger = schedulerEntry.getTrigger();
        this._delete(trigger.getJobName(), trigger.getGroupName(), storageType);
    }

    private void _delete(String groupName, StorageType storageType) throws SchedulerException {
        this._unregisterMessageListener(groupName, storageType);
        this._schedulerEngine.delete(this._namespaceGroupName(groupName, storageType));
    }

    private void _delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._unregisterMessageListener(jobName, groupName, storageType);
        this._schedulerEngine.delete(jobName, this._namespaceGroupName(groupName, storageType));
    }

    private Date _getEndTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("END_TIME");
        }
        return jobState.getTriggerDate("END_TIME");
    }

    private Date _getEndTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getEndTime(schedulerResponse);
        }
        return null;
    }

    private Date _getFinalFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("FINAL_FIRE_TIME");
        }
        return jobState.getTriggerDate("FINAL_FIRE_TIME");
    }

    private Date _getFinalFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getFinalFireTime(schedulerResponse);
        }
        return null;
    }

    private ObjectValuePair<Exception, Date>[] _getJobExceptions(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getExceptions();
    }

    private ObjectValuePair<Exception, Date>[] _getJobExceptions(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getJobExceptions(schedulerResponse);
        }
        return null;
    }

    private TriggerState _getJobState(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getTriggerState();
    }

    private TriggerState _getJobState(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getJobState(schedulerResponse);
        }
        return null;
    }

    private Date _getNextFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("NEXT_FIRE_TIME");
        }
        return jobState.getTriggerDate("NEXT_FIRE_TIME");
    }

    private Date _getNextFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getNextFireTime(schedulerResponse);
        }
        return null;
    }

    private Date _getPreviousFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("PREVIOUS_FIRE_TIME");
        }
        return jobState.getTriggerDate("PREVIOUS_FIRE_TIME");
    }

    private Date _getPreviousFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getPreviousFireTime(schedulerResponse);
        }
        return null;
    }

    private SchedulerResponse _getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJob(jobName, this._namespaceGroupName(groupName, storageType));
    }

    private List<SchedulerResponse> _getScheduledJobs() throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs();
    }

    private List<SchedulerResponse> _getScheduledJobs(StorageType storageType) throws SchedulerException {
        ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
        for (SchedulerResponse schedulerResponse : this._schedulerEngine.getScheduledJobs()) {
            if (!storageType.equals((Object)schedulerResponse.getStorageType())) continue;
            schedulerResponses.add(schedulerResponse);
        }
        return schedulerResponses;
    }

    private List<SchedulerResponse> _getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(this._namespaceGroupName(groupName, storageType));
    }

    private MessageListener _getSchedulerEventListener(SchedulerEntry schedulerEntry, ClassLoader classLoader) throws SchedulerException {
        try {
            MessageListener schedulerEventListener = (MessageListener)classLoader.loadClass(schedulerEntry.getEventListenerClass()).newInstance();
            return (MessageListener)ProxyUtil.newProxyInstance(classLoader, new Class[]{MessageListener.class}, new ClassLoaderBeanHandler(schedulerEventListener, classLoader));
        }
        catch (Exception e) {
            throw new SchedulerException(e);
        }
    }

    private Date _getStartTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("START_TIME");
        }
        return jobState.getTriggerDate("START_TIME");
    }

    private Date _getStartTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this._getStartTime(schedulerResponse);
        }
        return null;
    }

    private void _initialize() throws SchedulerException {
        if (this._schedulerEngineClusterManager != null) {
            this._schedulerEngineClusterManager.initialize();
        }
    }

    private String _namespaceGroupName(String groupName, StorageType storageType) {
        return storageType.toString().concat("#").concat(groupName);
    }

    private void _pause(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(this._namespaceGroupName(groupName, storageType));
    }

    private void _pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(jobName, this._namespaceGroupName(groupName, storageType));
    }

    private void _resume(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(this._namespaceGroupName(groupName, storageType));
    }

    private void _resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(jobName, this._namespaceGroupName(groupName, storageType));
    }

    private void _schedule(SchedulerEntry schedulerEntry, StorageType storageType, ClassLoader classLoader, int exceptionsMaxSize) throws SchedulerException {
        SchedulerEventMessageListenerWrapper schedulerEventListenerWrapper = new SchedulerEventMessageListenerWrapper();
        schedulerEventListenerWrapper.setClassName(schedulerEntry.getEventListenerClass());
        schedulerEventListenerWrapper.setMessageListener(this._getSchedulerEventListener(schedulerEntry, classLoader));
        schedulerEventListenerWrapper.afterPropertiesSet();
        schedulerEntry.setEventListener(schedulerEventListenerWrapper);
        MessageBusUtil.registerMessageListener("liferay/scheduler_dispatch", schedulerEventListenerWrapper);
        Message message = new Message();
        message.put("CONTEXT_PATH", schedulerEntry.getContextPath());
        message.put("MESSAGE_LISTENER_UUID", schedulerEventListenerWrapper.getMessageListenerUUID());
        this._schedule(schedulerEntry.getTrigger(), storageType, schedulerEntry.getDescription(), "liferay/scheduler_dispatch", message, exceptionsMaxSize);
    }

    private void _schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Message message, int exceptionsMaxSize) throws SchedulerException {
        if (message == null) {
            message = new Message();
        }
        message.put("EXCEPTIONS_MAX_SIZE", exceptionsMaxSize);
        trigger = TriggerFactoryUtil.buildTrigger(trigger.getTriggerType(), trigger.getJobName(), this._namespaceGroupName(trigger.getGroupName(), storageType), trigger.getStartDate(), trigger.getEndDate(), trigger.getTriggerContent());
        this._schedulerEngine.schedule(trigger, description, destinationName, message);
    }

    private void _schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Object payload, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.setPayload(payload);
        this._schedule(trigger, storageType, description, destinationName, message, exceptionsMaxSize);
    }

    private void _shutdown() throws SchedulerException {
        this._schedulerEngine.shutdown();
    }

    private void _start() throws SchedulerException {
        this._schedulerEngine.start();
    }

    private void _suppressError(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.suppressError(jobName, this._namespaceGroupName(groupName, storageType));
    }

    private void _unregisterMessageListener(SchedulerResponse schedulerResponse) {
        if (schedulerResponse == null) {
            return;
        }
        String destinationName = schedulerResponse.getDestinationName();
        if (!destinationName.equals("liferay/scheduler_dispatch")) {
            return;
        }
        Message message = schedulerResponse.getMessage();
        String messageListenerUUID = message.getString("MESSAGE_LISTENER_UUID");
        if (messageListenerUUID == null) {
            return;
        }
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        Destination destination = messageBus.getDestination("liferay/scheduler_dispatch");
        Set<MessageListener> messageListeners = destination.getMessageListeners();
        for (MessageListener messageListener : messageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)messageListener;
            SchedulerEventMessageListenerWrapper schedulerMessageListener = (SchedulerEventMessageListenerWrapper)invokerMessageListener.getMessageListener();
            if (!messageListenerUUID.equals(schedulerMessageListener.getMessageListenerUUID())) continue;
            MessageBusUtil.unregisterMessageListener("liferay/scheduler_dispatch", schedulerMessageListener);
            return;
        }
    }

    private void _unregisterMessageListener(String groupName, StorageType storageType) throws SchedulerException {
        List<SchedulerResponse> schedulerResponses = this._getScheduledJobs(groupName, storageType);
        for (SchedulerResponse schedulerResponse : schedulerResponses) {
            this._unregisterMessageListener(schedulerResponse);
        }
    }

    private void _unregisterMessageListener(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        this._unregisterMessageListener(schedulerResponse);
    }

    private void _unschedule(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        Trigger trigger = schedulerEntry.getTrigger();
        this._unschedule(trigger.getJobName(), trigger.getGroupName(), storageType);
    }

    private void _unschedule(String groupName, StorageType storageType) throws SchedulerException {
        this._unregisterMessageListener(groupName, storageType);
        this._schedulerEngine.unschedule(this._namespaceGroupName(groupName, storageType));
    }

    private void _unschedule(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._unregisterMessageListener(jobName, groupName, storageType);
        this._schedulerEngine.unschedule(jobName, this._namespaceGroupName(groupName, storageType));
    }

    private void _update(String jobName, String groupName, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse == null) {
            return;
        }
        Trigger trigger = schedulerResponse.getTrigger();
        if (trigger == null) {
            return;
        }
        Message message = schedulerResponse.getMessage();
        if (message == null) {
            return;
        }
        this._unregisterMessageListener(schedulerResponse);
        this._addScriptingJob(trigger, storageType, description, language, script, exceptionsMaxSize);
    }

    private void _update(Trigger trigger, StorageType storageType) throws SchedulerException {
        trigger = TriggerFactoryUtil.buildTrigger(trigger.getTriggerType(), trigger.getJobName(), this._namespaceGroupName(trigger.getGroupName(), storageType), trigger.getStartDate(), trigger.getEndDate(), trigger.getTriggerContent());
        this._schedulerEngine.update(trigger);
    }

    private void _updateMemorySchedulerClusterMaster() throws SchedulerException {
        if (this._schedulerEngineClusterManager == null) {
            _log.error("Unable to update memory scheduler cluster master because the portal is not using a clustered scheduler engine");
            return;
        }
        this._schedulerEngineClusterManager.updateMemorySchedulerClusterMaster();
    }
}

