/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.messaging;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.Date;

public class SchedulerEventMessageListenerWrapper
implements MessageListener {
    private String _className;
    private String _key;
    private MessageListener _messageListener;
    private String _messageListenerUUID;

    public void afterPropertiesSet() {
        String jobName = this._className;
        if (this._className.length() > SchedulerEngine.JOB_NAME_MAX_LENGTH) {
            jobName = this._className.substring(0, SchedulerEngine.JOB_NAME_MAX_LENGTH);
        }
        String groupName = this._className;
        if (this._className.length() > SchedulerEngine.GROUP_NAME_MAX_LENGTH) {
            groupName = this._className.substring(0, SchedulerEngine.GROUP_NAME_MAX_LENGTH);
        }
        this._key = jobName.concat(".").concat(groupName);
        if (this._messageListenerUUID == null) {
            this._messageListenerUUID = PortalUUIDUtil.generate();
        }
    }

    public String getMessageListenerUUID() {
        return this._messageListenerUUID;
    }

    public void receive(Message message) throws MessageListenerException {
        String receiverKey;
        String destinationName = GetterUtil.getString(message.getString("DESTINATION_NAME"));
        if (destinationName.equals("liferay/scheduler_dispatch") && !(receiverKey = GetterUtil.getString(message.getString("RECEIVER_KEY"))).equals(this._key)) {
            return;
        }
        try {
            try {
                this._messageListener.receive(message);
            }
            catch (Exception e) {
                this.handleException(message, e);
                if (e instanceof MessageListenerException) {
                    throw (MessageListenerException)e;
                }
                throw new MessageListenerException(e);
            }
        }
        finally {
            if (message.getBoolean("DISABLE") && destinationName.equals("liferay/scheduler_dispatch")) {
                MessageBusUtil.unregisterMessageListener(destinationName, this);
            }
        }
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setMessageListener(MessageListener messageListener) {
        this._messageListener = messageListener;
    }

    public void setMessageListenerUUID(String messageListenerUUID) {
        this._messageListenerUUID = messageListenerUUID;
    }

    protected void handleException(Message message, Exception exception) {
        JobState jobState = (JobState)message.get("JOB_STATE");
        if (jobState != null) {
            jobState.addException(exception, new Date());
        }
    }
}

