/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletURL;

public class FacetedSearcher
extends BaseIndexer {
    public static Indexer getInstance() {
        return new FacetedSearcher();
    }

    public String[] getClassNames() {
        return null;
    }

    public String getPortletId() {
        return null;
    }

    public IndexerPostProcessor[] getIndexerPostProcessors() {
        throw new UnsupportedOperationException();
    }

    public void registerIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        throw new UnsupportedOperationException();
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create(searchContext);
            contextQuery.addRequiredTerm("companyId", searchContext.getCompanyId());
            BooleanQuery fullQuery = this.createFullQuery(contextQuery, searchContext);
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            int start = searchContext.getStart();
            int end = searchContext.getEnd();
            if (this.isFilterSearch(searchContext) && permissionChecker != null) {
                searchContext.setStart(0);
                searchContext.setEnd(end + INDEX_FILTER_SEARCH_LIMIT);
            }
            Hits hits = SearchEngineUtil.search(searchContext, fullQuery);
            searchContext.setStart(start);
            searchContext.setEnd(end);
            if (this.isFilterSearch(searchContext) && permissionChecker != null) {
                hits = this.filterSearch(hits, permissionChecker, searchContext);
            }
            return hits;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public void unregisterIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        throw new UnsupportedOperationException();
    }

    protected void addSearchExpandoKeywords(BooleanQuery searchQuery, SearchContext searchContext, String keywords, String className) throws Exception {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge(searchContext.getCompanyId(), className);
        Set<String> attributeNames = SetUtil.fromEnumeration(expandoBridge.getAttributeNames());
        for (String attributeName : attributeNames) {
            UnicodeProperties properties = expandoBridge.getAttributeProperties(attributeName);
            int indexType = GetterUtil.getInteger(properties.getProperty("index-type"));
            if (indexType == 0) continue;
            String fieldName = ExpandoBridgeIndexerUtil.encodeFieldName(attributeName);
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm(fieldName, keywords);
                continue;
            }
            searchQuery.addTerm(fieldName, keywords);
        }
    }

    protected BooleanQuery createFullQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        BooleanClause[] booleanClauses;
        BooleanQuery searchQuery = BooleanQueryFactoryUtil.create(searchContext);
        String keywords = searchContext.getKeywords();
        if (Validator.isNotNull(keywords)) {
            searchQuery.addExactTerm("assetCategoryNames", keywords);
            searchQuery.addExactTerm("assetTagNames", keywords);
            searchQuery.addTerms(Field.KEYWORDS, keywords);
        }
        String[] stringArray = searchContext.getEntryClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entryClassName = stringArray[n2];
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer != null) {
                if (Validator.isNotNull(keywords)) {
                    this.addSearchExpandoKeywords(searchQuery, searchContext, keywords, entryClassName);
                }
                indexer.postProcessSearchQuery(searchQuery, searchContext);
                IndexerPostProcessor[] indexerPostProcessorArray = indexer.getIndexerPostProcessors();
                int n3 = indexerPostProcessorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IndexerPostProcessor indexerPostProcessor = indexerPostProcessorArray[n4];
                    indexerPostProcessor.postProcessSearchQuery(searchQuery, searchContext);
                    ++n4;
                }
            }
            ++n2;
        }
        Map<String, Facet> facets = searchContext.getFacets();
        for (Facet facet : facets.values()) {
            BooleanClause facetClause = facet.getFacetClause();
            if (facetClause == null) continue;
            contextQuery.add(facetClause.getQuery(), facetClause.getBooleanClauseOccur());
        }
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create(searchContext);
        fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
        if (searchQuery.hasClauses()) {
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            BooleanClause[] booleanClauseArray = booleanClauses;
            int n5 = booleanClauses.length;
            int n6 = 0;
            while (n6 < n5) {
                BooleanClause booleanClause = booleanClauseArray[n6];
                fullQuery.add(booleanClause.getQuery(), booleanClause.getBooleanClauseOccur());
                ++n6;
            }
        }
        String[] stringArray2 = searchContext.getEntryClassNames();
        int n7 = stringArray2.length;
        int n8 = 0;
        while (n8 < n7) {
            String entryClassName = stringArray2[n8];
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer != null) {
                IndexerPostProcessor[] indexerPostProcessorArray = indexer.getIndexerPostProcessors();
                int n9 = indexerPostProcessorArray.length;
                int n10 = 0;
                while (n10 < n9) {
                    IndexerPostProcessor indexerPostProcessor = indexerPostProcessorArray[n10];
                    indexerPostProcessor.postProcessFullQuery(fullQuery, searchContext);
                    ++n10;
                }
            }
            ++n8;
        }
        return fullQuery;
    }

    protected void doDelete(Object obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Document doGetDocument(Object obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(Object obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(String className, long classPK) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(String[] ids) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected String getPortletId(SearchContext searchContext) {
        return null;
    }

    protected boolean isFilterSearch(SearchContext searchContext) {
        if (searchContext.getEntryClassNames() == null) {
            return super.isFilterSearch();
        }
        String[] stringArray = searchContext.getEntryClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entryClassName = stringArray[n2];
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer != null && indexer.isFilterSearch()) {
                return true;
            }
            ++n2;
        }
        return super.isFilterSearch();
    }
}

