/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.search.facet.BaseFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.FacetValueValidator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class MultiValueFacet
extends BaseFacet {
    private static Log _log = LogFactoryUtil.getLog(MultiValueFacet.class);

    public MultiValueFacet(SearchContext searchContext) {
        super(searchContext);
    }

    protected BooleanClause doGetFacetClause() {
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        String[] values = null;
        if (this.isStatic() && dataJSONObject.has("values")) {
            JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
            values = new String[valuesJSONArray.length()];
            int i = 0;
            while (i < valuesJSONArray.length()) {
                values[i] = valuesJSONArray.getString(i);
                ++i;
            }
        }
        String[] valuesParam = StringUtil.split(GetterUtil.getString(searchContext.getAttribute(this.getFieldName())));
        if (!this.isStatic() && valuesParam != null && valuesParam.length > 0) {
            values = valuesParam;
        }
        if (values == null || values.length == 0) {
            return null;
        }
        BooleanQuery facetQuery = BooleanQueryFactoryUtil.create(searchContext);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            FacetValueValidator facetValueValidator = this.getFacetValueValidator();
            if (searchContext.getUserId() <= 0L || facetValueValidator.check(searchContext, value)) {
                TermQuery termQuery = TermQueryFactoryUtil.create(searchContext, this.getFieldName(), value);
                try {
                    facetQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                catch (ParseException pe) {
                    _log.error(pe, pe);
                }
            }
            ++n2;
        }
        if (!facetQuery.hasClauses()) {
            return null;
        }
        return BooleanClauseFactoryUtil.create(facetQuery, BooleanClauseOccur.MUST.getName());
    }
}

