/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;

public class ScopeFacet
extends MultiValueFacet {
    private static Log _log = LogFactoryUtil.getLog(ScopeFacet.class);

    public ScopeFacet(SearchContext searchContext) {
        super(searchContext);
        this.setFieldName("groupId");
    }

    protected BooleanClause doGetFacetClause() {
        String groupIdParam;
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        long[] groupIds = null;
        if (dataJSONObject.has("values")) {
            JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
            groupIds = new long[valuesJSONArray.length()];
            int i = 0;
            while (i < valuesJSONArray.length()) {
                groupIds[i] = valuesJSONArray.getLong(i);
                ++i;
            }
        }
        if (groupIds == null || groupIds.length == 0) {
            groupIds = searchContext.getGroupIds();
        }
        if (Validator.isNotNull(groupIdParam = GetterUtil.getString(searchContext.getAttribute("groupId")))) {
            groupIds = new long[]{GetterUtil.getLong(groupIdParam)};
        }
        if (groupIds == null || groupIds.length == 0 || groupIds.length == 1 && groupIds[0] == 0L) {
            return null;
        }
        BooleanQuery facetQuery = BooleanQueryFactoryUtil.create(searchContext);
        long ownerUserId = searchContext.getOwnerUserId();
        if (ownerUserId > 0L) {
            facetQuery.addRequiredTerm("userId", ownerUserId);
        }
        BooleanQuery groupIdsQuery = BooleanQueryFactoryUtil.create(searchContext);
        BooleanQuery scopeGroupIdsQuery = BooleanQueryFactoryUtil.create(searchContext);
        int i = 0;
        while (i < groupIds.length) {
            long groupId = groupIds[i];
            if (groupId > 0L) {
                try {
                    Group group = GroupLocalServiceUtil.getGroup(groupId);
                    if (group.isActive()) {
                        long parentGroupId = groupId;
                        if (group.isLayout()) {
                            parentGroupId = group.getParentGroupId();
                        }
                        groupIdsQuery.addTerm("groupId", parentGroupId);
                        groupIds[i] = parentGroupId;
                        if (group.isLayout() || searchContext.isScopeStrict()) {
                            scopeGroupIdsQuery.addTerm("scopeGroupId", groupId);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        searchContext.setGroupIds(groupIds);
        if (groupIdsQuery.hasClauses()) {
            try {
                facetQuery.add((Query)groupIdsQuery, BooleanClauseOccur.MUST);
            }
            catch (ParseException pe) {
                _log.error(pe, pe);
            }
        }
        if (scopeGroupIdsQuery.hasClauses()) {
            try {
                facetQuery.add((Query)scopeGroupIdsQuery, BooleanClauseOccur.MUST);
            }
            catch (ParseException pe) {
                _log.error(pe, pe);
            }
        }
        return BooleanClauseFactoryUtil.create(facetQuery, BooleanClauseOccur.MUST.getName());
    }
}

