/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFilter
implements LiferayFilter {
    private static final String _DEPTHER = "DEPTHER";
    private FilterConfig _filterConfig;
    private boolean _filterEnabled = true;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            this.processFilter(request, response, filterChain);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Exception e) {
            Log log = this.getLog();
            log.error(e, e);
        }
    }

    public FilterConfig getFilterConfig() {
        return this._filterConfig;
    }

    public void init(FilterConfig filterConfig) {
        this._filterConfig = filterConfig;
    }

    @Override
    public boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this._filterEnabled;
    }

    protected abstract Log getLog();

    protected void processFilter(Class<?> filterClass, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long startTime = 0L;
        String threadName = null;
        String depther = null;
        String path = null;
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            threadName = currentThread.getName();
            depther = (String)request.getAttribute(_DEPTHER);
            depther = depther == null ? "" : String.valueOf(depther) + "=";
            request.setAttribute(_DEPTHER, (Object)depther);
            path = request.getRequestURI();
            log.debug("[" + threadName + "]" + depther + "> " + filterClass.getName() + " " + path);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            depther = (String)request.getAttribute(_DEPTHER);
            if (depther == null) {
                return;
            }
            log.debug("[" + threadName + "]" + depther + "< " + filterClass.getName() + " " + path + " " + (endTime - startTime) + " ms");
            if (depther.length() > 0) {
                depther = depther.substring(1);
            }
            request.setAttribute(_DEPTHER, (Object)depther);
        }
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        throw new UnsupportedOperationException("Please implement processFilter(HttpServletRequest, HttpServletResponse, FilterChain)");
    }
}

