/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalClassLoaderFilter
extends BasePortalLifecycle
implements LiferayFilter {
    private Filter _filter;
    private FilterConfig _filterConfig;
    private LiferayFilter _liferayFilter;

    public void destroy() {
        this.portalDestroy();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            FilterChain contextClassLoaderFilterChain = (FilterChain)ProxyUtil.newProxyInstance(contextClassLoader, new Class[]{FilterChain.class}, new ClassLoaderBeanHandler(filterChain, contextClassLoader));
            InvokerFilterChain invokerFilterChain = new InvokerFilterChain(contextClassLoaderFilterChain);
            invokerFilterChain.addFilter(this._filter);
            invokerFilterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void init(FilterConfig filterConfig) {
        this._filterConfig = filterConfig;
        this.registerPortalLifecycle();
    }

    public boolean isFilterEnabled() {
        if (this._liferayFilter != null) {
            return this._liferayFilter.isFilterEnabled();
        }
        return true;
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        if (this._liferayFilter != null) {
            return this._liferayFilter.isFilterEnabled(request, response);
        }
        return true;
    }

    protected void doPortalDestroy() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._filter.destroy();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void doPortalInit() throws Exception {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        String filterClass = this._filterConfig.getInitParameter("filter-class");
        if (filterClass.startsWith("com.liferay.filters.")) {
            filterClass = StringUtil.replace(filterClass, "com.liferay.filters.", "com.liferay.portal.servlet.filters.");
        }
        this._filter = (Filter)classLoader.loadClass(filterClass).newInstance();
        this._filter.init(this._filterConfig);
        if (this._filter instanceof LiferayFilter) {
            this._liferayFilter = (LiferayFilter)this._filter;
        }
    }
}

