/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public abstract class PortalClassLoaderServletContextListener
extends BasePortalLifecycle
implements ServletContextListener {
    private ServletContextEvent _servletContextEvent;
    private ServletContextListener _servletContextListener;
    private ClassLoader _portletClassLoader;
    private String _servletContextName;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.portalDestroy();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this._servletContextEvent = servletContextEvent;
        ServletContext servletContext = servletContextEvent.getServletContext();
        this._servletContextName = servletContext.getServletContextName();
        Thread currentThread = Thread.currentThread();
        this._portletClassLoader = currentThread.getContextClassLoader();
        this.registerPortalLifecycle();
    }

    protected void doPortalDestroy() {
        PortletClassLoaderUtil.setClassLoader(this._portletClassLoader);
        PortletClassLoaderUtil.setServletContextName(this._servletContextName);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._servletContextListener.contextDestroyed(this._servletContextEvent);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
            PortletClassLoaderUtil.setClassLoader(null);
            PortletClassLoaderUtil.setServletContextName(null);
        }
    }

    protected void doPortalInit() throws Exception {
        PortletClassLoaderUtil.setClassLoader(this._portletClassLoader);
        PortletClassLoaderUtil.setServletContextName(this._servletContextName);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._servletContextListener = this.getInstance();
            this._servletContextListener.contextInitialized(this._servletContextEvent);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected abstract ServletContextListener getInstance() throws Exception;
}

