/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalDelegatorServlet;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;

public class PortalDelegateServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(PortalDelegateServlet.class);
    private String _subContext;

    public void init(ServletConfig servletConfig) {
        String servletClass = servletConfig.getInitParameter("servlet-class");
        this._subContext = servletConfig.getInitParameter("sub-context");
        if (this._subContext == null) {
            this._subContext = this.getServletName();
        }
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            HttpServlet servlet = (HttpServlet)contextClassLoader.loadClass(servletClass).newInstance();
            servlet.init(servletConfig);
            PortalDelegatorServlet.addDelegate(this._subContext, servlet);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public void destroy() {
        PortalDelegatorServlet.removeDelegate(this._subContext);
    }
}

