/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;

public class PortletContextListener
extends BasePortalLifecycle
implements ServletContextListener {
    private static final String _JNDI_JDBC = "java_liferay:jdbc";
    private static final String _JNDI_JDBC_LIFERAY_POOL = "java_liferay:jdbc/LiferayPool";
    private static Log _log = LogFactoryUtil.getLog(PortletContextListener.class);
    private boolean _bindLiferayPool;
    private ClassLoader _portletClassLoader;
    private ServletContext _servletContext;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.portalDestroy();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this._servletContext = servletContextEvent.getServletContext();
        Thread currentThread = Thread.currentThread();
        this._portletClassLoader = currentThread.getContextClassLoader();
        this.registerPortalLifecycle();
    }

    protected void doPortalDestroy() {
        block8: {
            HotDeployUtil.fireUndeployEvent(new HotDeployEvent(this._servletContext, this._portletClassLoader));
            try {
                if (!this._bindLiferayPool) {
                    return;
                }
                this._bindLiferayPool = false;
                if (_log.isDebugEnabled()) {
                    _log.debug("Dynamically unbinding the Liferay data source");
                }
                InitialContext context = new InitialContext();
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                    context.unbind(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException namingException) {}
                try {
                    context.lookup(_JNDI_JDBC);
                    context.destroySubcontext(_JNDI_JDBC);
                }
                catch (NamingException namingException) {}
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn("Unable to dynamically unbind the Liferay data source: " + e.getMessage());
            }
        }
    }

    protected void doPortalInit() throws Exception {
        block12: {
            DataSource dataSource;
            HotDeployUtil.fireDeployEvent(new HotDeployEvent(this._servletContext, this._portletClassLoader));
            if (ServerDetector.isGlassfish() || ServerDetector.isJOnAS()) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Dynamically binding the Liferay data source");
            }
            if ((dataSource = InfrastructureUtil.getDataSource()) == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Abort dynamically binding the Liferay data source because it is not available");
                }
                return;
            }
            InitialContext context = new InitialContext();
            try {
                try {
                    context.lookup(_JNDI_JDBC);
                }
                catch (NamingException namingException) {
                    context.createSubcontext(_JNDI_JDBC);
                }
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException namingException) {
                    try {
                        Class<?> clazz = dataSource.getClass();
                        Method method = clazz.getMethod("getTargetDataSource", new Class[0]);
                        dataSource = (DataSource)method.invoke((Object)dataSource, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    context.bind(_JNDI_JDBC_LIFERAY_POOL, (Object)dataSource);
                }
                this._bindLiferayPool = true;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block12;
                _log.warn("Unable to dynamically bind the Liferay data source: " + e.getMessage());
            }
        }
    }
}

