/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

public class SerializableSessionAttributeListener
extends BasePortalLifecycle
implements HttpSessionAttributeListener {
    private static Log _log = LogFactoryUtil.getLog(SerializableSessionAttributeListener.class);
    private Boolean _requiresSerializable;
    private boolean _sessionVerifySerializableAttribute;

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (!this._sessionVerifySerializableAttribute) {
            return;
        }
        String name = event.getName();
        Object value = event.getValue();
        if (!(value instanceof Serializable)) {
            HttpSession session;
            _log.error(String.valueOf(value.getClass().getName()) + " is not serializable and will prevent this session from " + "being replicated");
            if (this._requiresSerializable == null) {
                session = event.getSession();
                ServletContext servletContext = session.getServletContext();
                this._requiresSerializable = GetterUtil.getBoolean(servletContext.getInitParameter("session-attributes-requires-serializable"));
            }
            if (this._requiresSerializable.booleanValue()) {
                session = event.getSession();
                session.removeAttribute(name);
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.attributeAdded(event);
    }

    protected void doPortalDestroy() throws Exception {
    }

    protected void doPortalInit() throws Exception {
        this._sessionVerifySerializableAttribute = GetterUtil.getBoolean(PropsUtil.get("session.verify.serializable.attribute"), true);
    }
}

