/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextUtil {
    public static final String LOG_INFO_PREFIX = "Please configure Tomcat to unpack WARs to enable ";
    public static final String LOG_INFO_LAST_MODIFIED = "Please configure Tomcat to unpack WARs to enable retrieval of the most recent last modified date of a WAR for best performance";
    public static final String LOG_INFO_SPRITES = "Please configure Tomcat to unpack WARs to enable enable sprites for best performance";
    private static final String _EXT_CLASS = ".class";
    private static final String _EXT_JAR = ".jar";
    private static Log _log = LogFactoryUtil.getLog(ServletContextUtil.class);

    public static Set<String> getClassNames(ServletContext servletContext) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        ServletContextUtil._getClassNames(servletContext, "/WEB-INF/classes", classNames);
        ServletContextUtil._getClassNames(servletContext, "/WEB-INF/lib", classNames);
        return classNames;
    }

    public static long getLastModified(ServletContext servletContext) {
        return ServletContextUtil.getLastModified(servletContext, "/");
    }

    public static long getLastModified(ServletContext servletContext, String resourcePath) {
        return ServletContextUtil.getLastModified(servletContext, resourcePath, false);
    }

    public static long getLastModified(ServletContext servletContext, String resourcePath, boolean cache) {
        Long lastModified;
        if (cache && (lastModified = (Long)servletContext.getAttribute(String.valueOf(ServletContextUtil.class.getName()) + "." + resourcePath)) != null) {
            return lastModified;
        }
        long lastModified2 = 0L;
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths != null) {
            for (String curResourcePath : resourcePaths) {
                if (curResourcePath.endsWith("/")) {
                    long curLastModified = ServletContextUtil.getLastModified(servletContext, curResourcePath);
                    if (curLastModified <= lastModified2) continue;
                    lastModified2 = curLastModified;
                    continue;
                }
                String realPath = ServletContextUtil.getRealPath(servletContext, curResourcePath);
                if (realPath == null) {
                    if (ServerDetector.isTomcat()) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info(LOG_INFO_LAST_MODIFIED);
                        continue;
                    }
                    _log.error("Real path for " + curResourcePath + " is null");
                    continue;
                }
                File file = new File(realPath);
                if (file.lastModified() <= lastModified2) continue;
                lastModified2 = file.lastModified();
            }
        }
        if (cache) {
            servletContext.setAttribute(String.valueOf(ServletContextUtil.class.getName()) + "." + resourcePath, (Object)new Long(lastModified2));
        }
        return lastModified2;
    }

    public static String getRealPath(ServletContext servletContext, String path) {
        String realPath = servletContext.getRealPath(path);
        if (realPath == null && ServerDetector.isWebLogic()) {
            String rootDir = ServletContextUtil.getRootDir(servletContext);
            realPath = path.startsWith("/") ? String.valueOf(rootDir) + path.substring(1) : String.valueOf(rootDir) + path;
            if (!FileUtil.exists(realPath)) {
                realPath = null;
            }
        }
        return realPath;
    }

    protected static String getRootDir(ServletContext servletContext) {
        String key = String.valueOf(ServletContextUtil.class.getName()) + ".rootDir";
        String rootDir = (String)servletContext.getAttribute(key);
        if (rootDir == null) {
            ClassLoader classLoader = (ClassLoader)servletContext.getAttribute("PORTLET_CLASS_LOADER");
            if (classLoader == null) {
                classLoader = PortalClassLoaderUtil.getClassLoader();
            }
            rootDir = WebDirDetector.getRootDir(classLoader);
            servletContext.setAttribute(key, (Object)rootDir);
        }
        return rootDir;
    }

    private static String _getClassName(String path) {
        return ServletContextUtil._getClassName(null, path);
    }

    private static String _getClassName(String rootResourcePath, String path) {
        String className = path.substring(0, path.length() - _EXT_CLASS.length());
        if (rootResourcePath != null) {
            className = className.substring(rootResourcePath.length() + 1);
        }
        className = StringUtil.replace(className, '/', '.');
        return className;
    }

    private static void _getClassNames(ServletContext servletContext, String rootResourcePath, Set<String> classNames) throws IOException {
        ServletContextUtil._getClassNames(servletContext, rootResourcePath, servletContext.getResourcePaths(rootResourcePath), classNames);
    }

    private static void _getClassNames(ServletContext servletContext, String rootResourcePath, Set<String> resourcePaths, Set<String> classNames) throws IOException {
        if (resourcePaths == null) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(_EXT_CLASS)) {
                String className = ServletContextUtil._getClassName(rootResourcePath, resourcePath);
                classNames.add(className);
                continue;
            }
            if (resourcePath.endsWith(_EXT_JAR)) {
                JarEntry jarEntry;
                JarInputStream jarFile = new JarInputStream(servletContext.getResourceAsStream(resourcePath));
                while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(_EXT_CLASS)) continue;
                    String className = ServletContextUtil._getClassName(jarEntryName);
                    classNames.add(className);
                }
                jarFile.close();
                continue;
            }
            if (!resourcePath.endsWith("/")) continue;
            ServletContextUtil._getClassNames(servletContext, rootResourcePath, servletContext.getResourcePaths(resourcePath), classNames);
        }
    }
}

