/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionErrors {
    public static void add(HttpServletRequest request, String key) {
        SessionErrors.add(request.getSession(), key);
    }

    public static void add(HttpServletRequest request, String key, Object value) {
        SessionErrors.add(request.getSession(), key, value);
    }

    public static void add(HttpSession session, String key) {
        Map<String, Object> errors = SessionErrors._getErrors(session, true);
        errors.put(key, key);
    }

    public static void add(HttpSession session, String key, Object value) {
        Map<String, Object> errors = SessionErrors._getErrors(session, true);
        errors.put(key, value);
    }

    public static void add(PortletRequest portletRequest, String key) {
        SessionErrors.add(portletRequest.getPortletSession(), key);
    }

    public static void add(PortletRequest portletRequest, String key, Object value) {
        SessionErrors.add(portletRequest.getPortletSession(), key, value);
    }

    public static void add(PortletSession portletSession, String key) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, true);
        errors.put(key, key);
    }

    public static void add(PortletSession portletSession, String key, Object value) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, true);
        errors.put(key, value);
    }

    public static void clear(HttpServletRequest request) {
        SessionErrors.clear(request.getSession());
    }

    public static void clear(HttpSession session) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors != null) {
            errors.clear();
        }
    }

    public static void clear(PortletRequest portletRequest) {
        SessionErrors.clear(portletRequest.getPortletSession());
    }

    public static void clear(PortletSession portletSession) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors != null) {
            errors.clear();
        }
    }

    public static boolean contains(HttpServletRequest request, String key) {
        return SessionErrors.contains(request.getSession(), key);
    }

    public static boolean contains(HttpSession session, String key) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors == null) {
            return false;
        }
        return errors.containsKey(key);
    }

    public static boolean contains(PortletRequest portletRequest, String key) {
        return SessionErrors.contains(portletRequest.getPortletSession(), key);
    }

    public static boolean contains(PortletSession portletSession, String key) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors == null) {
            return false;
        }
        return errors.containsKey(key);
    }

    public static Object get(HttpServletRequest request, String key) {
        return SessionErrors.get(request.getSession(), key);
    }

    public static Object get(HttpSession session, String key) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors == null) {
            return null;
        }
        return errors.get(key);
    }

    public static Object get(PortletRequest portletRequest, String key) {
        return SessionErrors.get(portletRequest.getPortletSession(), key);
    }

    public static Object get(PortletSession portletSession, String key) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors == null) {
            return null;
        }
        return errors.get(key);
    }

    public static boolean isEmpty(HttpServletRequest request) {
        return SessionErrors.isEmpty(request.getSession());
    }

    public static boolean isEmpty(HttpSession session) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors == null) {
            return true;
        }
        return errors.isEmpty();
    }

    public static boolean isEmpty(PortletRequest portletRequest) {
        return SessionErrors.isEmpty(portletRequest.getPortletSession());
    }

    public static boolean isEmpty(PortletSession portletSession) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors == null) {
            return true;
        }
        return errors.isEmpty();
    }

    public static Iterator<String> iterator(HttpServletRequest request) {
        return SessionErrors.iterator(request.getSession());
    }

    public static Iterator<String> iterator(HttpSession session) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.unmodifiableSet(errors.keySet()).iterator();
    }

    public static Iterator<String> iterator(PortletRequest portletRequest) {
        return SessionErrors.iterator(portletRequest.getPortletSession());
    }

    public static Iterator<String> iterator(PortletSession portletSession) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.unmodifiableSet(errors.keySet()).iterator();
    }

    public static Set<String> keySet(HttpServletRequest request) {
        return SessionErrors.keySet(request.getSession());
    }

    public static Set<String> keySet(HttpSession session) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(errors.keySet());
    }

    public static Set<String> keySet(PortletRequest portletRequest) {
        return SessionErrors.keySet(portletRequest.getPortletSession());
    }

    public static Set<String> keySet(PortletSession portletSession) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(errors.keySet());
    }

    public static void print(HttpServletRequest request) {
        SessionErrors.print(request.getSession());
    }

    public static void print(HttpSession session) {
        Iterator<String> itr = SessionErrors.iterator(session);
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public static void print(PortletRequest portletRequest) {
        SessionErrors.print(portletRequest.getPortletSession());
    }

    public static void print(PortletSession portletSession) {
        Iterator<String> itr = SessionErrors.iterator(portletSession);
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public static int size(HttpServletRequest request) {
        return SessionErrors.size(request.getSession());
    }

    public static int size(HttpSession session) {
        Map<String, Object> errors = SessionErrors._getErrors(session, false);
        if (errors == null) {
            return 0;
        }
        return errors.size();
    }

    public static int size(PortletRequest portletRequest) {
        return SessionErrors.size(portletRequest.getPortletSession());
    }

    public static int size(PortletSession portletSession) {
        Map<String, Object> errors = SessionErrors._getErrors(portletSession, false);
        if (errors == null) {
            return 0;
        }
        return errors.size();
    }

    private static Map<String, Object> _getErrors(HttpSession session, boolean createIfAbsent) {
        LinkedHashMap errors = null;
        try {
            errors = (LinkedHashMap)session.getAttribute(SessionErrors.class.getName());
            if (errors == null && createIfAbsent) {
                errors = new LinkedHashMap();
                session.setAttribute(SessionErrors.class.getName(), errors);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return errors;
    }

    private static Map<String, Object> _getErrors(PortletSession portletSession, boolean createIfAbsent) {
        LinkedHashMap errors = null;
        try {
            errors = (LinkedHashMap)portletSession.getAttribute(SessionErrors.class.getName());
            if (errors == null && createIfAbsent) {
                errors = new LinkedHashMap();
                portletSession.setAttribute(SessionErrors.class.getName(), errors);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return errors;
    }
}

