/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMessages {
    public static final String KEY_SUFFIX_CLOSE_REDIRECT = ".closeRedirect";
    public static final String KEY_SUFFIX_HIDE_DEFAULT_ERROR_MESSAGE = ".hideDefaultErrorMessage";
    public static final String KEY_SUFFIX_PORTLET_NOT_AJAXABLE = ".portletNotAjaxable";
    public static final String KEY_SUFFIX_REFRESH_PORTLET = ".refreshPortlet";
    public static final String KEY_SUFFIX_REFRESH_PORTLET_DATA = ".refreshPortletData";
    public static final String KEY_SUFFIX_UPDATED_CONFIGURATION = ".updatedConfiguration";
    public static final String KEY_SUFFIX_UPDATED_PREFERENCES = ".updatedPreferences";

    public static void add(HttpServletRequest request, String key) {
        SessionMessages.add(request.getSession(), key);
    }

    public static void add(HttpServletRequest request, String key, Object value) {
        SessionMessages.add(request.getSession(), key, value);
    }

    public static void add(HttpSession session, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(session, true);
        messages.put(key, key);
    }

    public static void add(HttpSession session, String key, Object value) {
        Map<String, Object> messages = SessionMessages._getMessages(session, true);
        messages.put(key, value);
    }

    public static void add(PortletRequest portletRequest, String key) {
        SessionMessages.add(portletRequest.getPortletSession(), key);
    }

    public static void add(PortletRequest portletRequest, String key, Object value) {
        SessionMessages.add(portletRequest.getPortletSession(), key, value);
    }

    public static void add(PortletSession portletSession, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, true);
        messages.put(key, key);
    }

    public static void add(PortletSession portletSession, String key, Object value) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, true);
        messages.put(key, value);
    }

    public static void clear(HttpServletRequest request) {
        SessionMessages.clear(request.getSession());
    }

    public static void clear(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session, false);
        if (messages != null) {
            messages.clear();
        }
    }

    public static void clear(PortletRequest portletRequest) {
        SessionMessages.clear(portletRequest.getPortletSession());
    }

    public static void clear(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, false);
        if (messages != null) {
            messages.clear();
        }
    }

    public static boolean contains(HttpServletRequest request, String key) {
        return SessionMessages.contains(request.getSession(), key);
    }

    public static boolean contains(HttpSession session, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(session, false);
        if (messages == null) {
            return false;
        }
        return messages.containsKey(key);
    }

    public static boolean contains(PortletRequest portletRequest, String key) {
        return SessionMessages.contains(portletRequest.getPortletSession(), key);
    }

    public static boolean contains(PortletSession portletSession, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, false);
        if (messages == null) {
            return false;
        }
        return messages.containsKey(key);
    }

    public static Object get(HttpServletRequest request, String key) {
        return SessionMessages.get(request.getSession(), key);
    }

    public static Object get(HttpSession session, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(session, false);
        if (messages == null) {
            return null;
        }
        return messages.get(key);
    }

    public static Object get(PortletRequest portletRequest, String key) {
        return SessionMessages.get(portletRequest.getPortletSession(), key);
    }

    public static Object get(PortletSession portletSession, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, false);
        if (messages == null) {
            return null;
        }
        return messages.get(key);
    }

    public static boolean isEmpty(HttpServletRequest request) {
        return SessionMessages.isEmpty(request.getSession());
    }

    public static boolean isEmpty(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session, false);
        if (messages == null) {
            return true;
        }
        return messages.isEmpty();
    }

    public static boolean isEmpty(PortletRequest portletRequest) {
        return SessionMessages.isEmpty(portletRequest.getPortletSession());
    }

    public static boolean isEmpty(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, false);
        if (messages == null) {
            return true;
        }
        return messages.isEmpty();
    }

    public static Iterator<String> iterator(HttpServletRequest request) {
        return SessionMessages.iterator(request.getSession());
    }

    public static Iterator<String> iterator(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session, false);
        if (messages == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.unmodifiableSet(messages.keySet()).iterator();
    }

    public static Iterator<String> iterator(PortletRequest portletRequest) {
        return SessionMessages.iterator(portletRequest.getPortletSession());
    }

    public static Iterator<String> iterator(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, false);
        if (messages == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.unmodifiableSet(messages.keySet()).iterator();
    }

    public static void print(HttpServletRequest request) {
        SessionMessages.print(request.getSession());
    }

    public static void print(HttpSession session) {
        Iterator<String> itr = SessionMessages.iterator(session);
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public static void print(PortletRequest portletRequest) {
        SessionMessages.print(portletRequest.getPortletSession());
    }

    public static void print(PortletSession portletSession) {
        Iterator<String> itr = SessionMessages.iterator(portletSession);
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public static int size(HttpServletRequest request) {
        return SessionMessages.size(request.getSession());
    }

    public static int size(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session, false);
        if (messages == null) {
            return 0;
        }
        return messages.size();
    }

    public static int size(PortletRequest portletRequest) {
        return SessionMessages.size(portletRequest.getPortletSession());
    }

    public static int size(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession, false);
        if (messages == null) {
            return 0;
        }
        return messages.size();
    }

    private static Map<String, Object> _getMessages(HttpSession session, boolean createIfAbsent) {
        LinkedHashMap messages = null;
        try {
            messages = (LinkedHashMap)session.getAttribute(SessionMessages.class.getName());
            if (messages == null && createIfAbsent) {
                messages = new LinkedHashMap();
                session.setAttribute(SessionMessages.class.getName(), messages);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return messages;
    }

    private static Map<String, Object> _getMessages(PortletSession portletSession, boolean createIfAbsent) {
        LinkedHashMap messages = null;
        try {
            messages = (LinkedHashMap)portletSession.getAttribute(SessionMessages.class.getName());
            if (messages == null && createIfAbsent) {
                messages = new LinkedHashMap();
                portletSession.setAttribute(SessionMessages.class.getName(), messages);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return messages;
    }
}

