/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;

public class TrimNewLinesJspWriter
extends JspWriter {
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean _lastNewLine;
    private Writer _writer;

    public TrimNewLinesJspWriter(Writer writer) {
        super(0, false);
        this._writer = writer;
    }

    public void clear() throws IOException {
        throw new IOException();
    }

    public void clearBuffer() {
    }

    public void close() throws IOException {
        this._writer.close();
    }

    public void flush() throws IOException {
        this._writer.flush();
    }

    public int getRemaining() {
        return 0;
    }

    public void newLine() throws IOException {
        if (!this._lastNewLine) {
            this._writer.write(_LINE_SEPARATOR);
            this._lastNewLine = true;
        }
    }

    public void print(boolean b) throws IOException {
        if (b) {
            this._writer.write("true");
        } else {
            this._writer.write("false");
        }
        this._lastNewLine = false;
    }

    public void print(char c) throws IOException {
        boolean newLine = false;
        if (c == '\n' || c == '\r') {
            newLine = true;
        }
        if (!this._lastNewLine || !newLine) {
            this._writer.write(c);
        }
        if (newLine) {
            this._lastNewLine = true;
        }
    }

    public void print(char[] chars) throws IOException {
        this._writer.write(chars);
        this._lastNewLine = false;
    }

    public void print(double d) throws IOException {
        this._writer.write(String.valueOf(d));
        this._lastNewLine = false;
    }

    public void print(float f) throws IOException {
        this._writer.write(String.valueOf(f));
        this._lastNewLine = false;
    }

    public void print(int i) throws IOException {
        this._writer.write(String.valueOf(i));
        this._lastNewLine = false;
    }

    public void print(long l) throws IOException {
        this._writer.write(String.valueOf(l));
        this._lastNewLine = false;
    }

    public void print(Object object) throws IOException {
        this._writer.write(String.valueOf(object));
        this._lastNewLine = false;
    }

    public void print(String string) throws IOException {
        if ((string = string == null ? "null" : this.trim(string)).length() > 0) {
            this._writer.write(string);
            this._lastNewLine = false;
        }
    }

    public void println() throws IOException {
        if (!this._lastNewLine) {
            this._writer.write(_LINE_SEPARATOR);
            this._lastNewLine = true;
        }
    }

    public void println(boolean b) throws IOException {
        if (b) {
            this._writer.write("true");
        } else {
            this._writer.write("false");
        }
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(char c) throws IOException {
        this._writer.write(c);
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(char[] chars) throws IOException {
        this._writer.write(chars);
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(double d) throws IOException {
        this._writer.write(String.valueOf(d));
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(float f) throws IOException {
        this._writer.write(String.valueOf(f));
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(int i) throws IOException {
        this._writer.write(String.valueOf(i));
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(long l) throws IOException {
        this._writer.write(String.valueOf(l));
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(Object object) throws IOException {
        this._writer.write(String.valueOf(object));
        this._writer.write(_LINE_SEPARATOR);
        this._lastNewLine = true;
    }

    public void println(String string) throws IOException {
        if ((string = string == null ? "null" : this.trim(string)).length() > 0) {
            this._writer.write(string);
            this._lastNewLine = true;
        }
    }

    public void write(char[] chars) throws IOException {
        this._writer.write(chars);
        this._lastNewLine = false;
    }

    public void write(char[] chars, int offset, int length) throws IOException {
        this._writer.write(chars, offset, length);
        this._lastNewLine = false;
    }

    public void write(int c) throws IOException {
        boolean newLine = false;
        if (c == 10 || c == 13) {
            newLine = true;
        }
        if (!this._lastNewLine || !newLine) {
            this._writer.write(c);
        }
        if (newLine) {
            this._lastNewLine = true;
        }
    }

    public void write(String string) throws IOException {
        if (string.length() > 0) {
            this._writer.write(string);
            this._lastNewLine = false;
        }
    }

    public void write(String string, int offset, int length) throws IOException {
        if ((string = this.trim(string.substring(offset, offset + length))).length() > 0) {
            this._writer.write(string);
            this._lastNewLine = false;
        }
    }

    protected String trim(String string) {
        int length;
        int start = length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') {
                start = i;
                break;
            }
            ++i;
        }
        int end = 0;
        int i2 = length - 1;
        while (i2 >= 0) {
            char c = string.charAt(i2);
            if (c != '\n' && c != '\r') {
                end = i2 + 1;
                break;
            }
            --i2;
        }
        if (end > start) {
            return string.substring(start, end);
        }
        return "";
    }
}

