/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.templateparser.TemplateContext;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.templateparser.TemplateParser;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTemplateParser
implements TemplateParser {
    private String _languageId;
    private String _script;
    private ThemeDisplay _themeDisplay;
    private Map<String, String> _tokens;
    private String _viewMode;
    private String _xml;

    @Override
    public String getLanguageId() {
        return this._languageId;
    }

    @Override
    public String getScript() {
        return this._script;
    }

    @Override
    public ThemeDisplay getThemeDisplay() {
        return this._themeDisplay;
    }

    @Override
    public Map<String, String> getTokens() {
        return this._tokens;
    }

    @Override
    public String getViewMode() {
        return this._viewMode;
    }

    @Override
    public String getXML() {
        return this._xml;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    @Override
    public void setScript(String script) {
        this._script = script;
    }

    @Override
    public void setThemeDisplay(ThemeDisplay themeDisplay) {
        this._themeDisplay = themeDisplay;
    }

    @Override
    public void setTokens(Map<String, String> tokens) {
        this._tokens = tokens;
    }

    @Override
    public void setViewMode(String viewMode) {
        this._viewMode = viewMode;
    }

    @Override
    public void setXML(String xml) {
        this._xml = xml;
    }

    @Override
    public String transform() throws TransformException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        boolean load = false;
        try {
            TemplateContext templateContext = this.getTemplateContext();
            Document document = SAXReaderUtil.read(this._xml);
            Element rootElement = document.getRootElement();
            List<TemplateNode> templateNodes = this.getTemplateNodes(rootElement);
            if (templateNodes != null) {
                for (TemplateNode templateNode : templateNodes) {
                    templateContext.put(templateNode.getName(), templateNode);
                }
            }
            Element requestElement = rootElement.element("request");
            templateContext.put("request", this.insertRequestVariables(requestElement));
            templateContext.put("xmlRequest", requestElement.asXML());
            this.populateTemplateContext(templateContext);
            load = this.mergeTemplate(templateContext, unsyncStringWriter);
        }
        catch (Exception e) {
            if (e instanceof DocumentException) {
                throw new TransformException("Unable to read XML document", e);
            }
            if (e instanceof IOException) {
                throw new TransformException("Error reading template", e);
            }
            if (e instanceof TransformException) {
                throw (TransformException)e;
            }
            throw new TransformException("Unhandled exception", e);
        }
        if (!load) {
            throw new TransformException("Unable to dynamically load transform script");
        }
        return unsyncStringWriter.toString();
    }

    protected Company getCompany() throws Exception {
        long companyId = this.getCompanyId();
        return CompanyLocalServiceUtil.getCompany(companyId);
    }

    protected long getCompanyId() {
        return GetterUtil.getLong(this._tokens.get("company_id"));
    }

    protected long getGroupId() {
        return GetterUtil.getLong(this._tokens.get("group_id"));
    }

    protected abstract TemplateContext getTemplateContext() throws Exception;

    protected String getTemplateId() {
        long companyGroupId = GetterUtil.getLong(this._tokens.get("company_group_id"));
        String templateId = this._tokens.get("template_id");
        if (companyGroupId > 0L) {
            return String.valueOf(this.getCompanyId() + companyGroupId) + templateId;
        }
        return String.valueOf(this.getCompanyId() + this.getGroupId()) + templateId;
    }

    protected abstract List<TemplateNode> getTemplateNodes(Element var1) throws Exception;

    protected Map<String, Object> insertRequestVariables(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (element == null) {
            return map;
        }
        for (Element childElement : element.elements()) {
            Element nameElement;
            String name = childElement.getName();
            if (name.equals("attribute")) {
                nameElement = childElement.element("name");
                Element valueElement = childElement.element("value");
                map.put(nameElement.getText(), valueElement.getText());
                continue;
            }
            if (name.equals("parameter")) {
                nameElement = childElement.element("name");
                List<Element> valueElements = childElement.elements("value");
                if (valueElements.size() == 1) {
                    Element valueElement = valueElements.get(0);
                    map.put(nameElement.getText(), valueElement.getText());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Element valueElement : valueElements) {
                    values.add(valueElement.getText());
                }
                map.put(nameElement.getText(), values);
                continue;
            }
            if (childElement.elements().size() > 0) {
                map.put(name, this.insertRequestVariables(childElement));
                continue;
            }
            map.put(name, childElement.getText());
        }
        return map;
    }

    protected abstract boolean mergeTemplate(TemplateContext var1, UnsyncStringWriter var2) throws Exception;

    protected void populateTemplateContext(TemplateContext templateContext) throws Exception {
        templateContext.put("company", this.getCompany());
        templateContext.put("companyId", this.getCompanyId());
        templateContext.put("device", this._themeDisplay.getDevice());
        templateContext.put("groupId", this.getGroupId());
        Locale locale = LocaleUtil.fromLanguageId(this._languageId);
        templateContext.put("locale", locale);
        templateContext.put("permissionChecker", PermissionThreadLocal.getPermissionChecker());
        templateContext.put("viewMode", this._viewMode);
    }
}

