/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralizedThreadLocal<T>
extends ThreadLocal<T> {
    private static final int _HASH_INCREMENT = 1640531527;
    private static Log _log = LogFactoryUtil.getLog(CentralizedThreadLocal.class);
    private static final AtomicInteger _longLivedNextHasCode = new AtomicInteger();
    private static final ThreadLocal<ThreadLocalMap> _longLivedThreadLocals = new ThreadLocalMapThreadLocal();
    private static final AtomicInteger _shortLivedNextHasCode = new AtomicInteger();
    private static final ThreadLocal<ThreadLocalMap> _shortLivedThreadLocals = new ThreadLocalMapThreadLocal();
    private final int _hashCode;
    private final boolean _shortLived;

    public static void clearLongLivedThreadLocals() {
        _longLivedThreadLocals.remove();
    }

    public static void clearShortLivedThreadLocals() {
        _shortLivedThreadLocals.remove();
    }

    public static Map<CentralizedThreadLocal<?>, Object> getLongLivedThreadLocals() {
        return CentralizedThreadLocal._toMap(_longLivedThreadLocals.get());
    }

    public static Map<CentralizedThreadLocal<?>, Object> getShortLivedThreadLocals() {
        return CentralizedThreadLocal._toMap(_shortLivedThreadLocals.get());
    }

    public static void setThreadLocals(Map<CentralizedThreadLocal<?>, Object> longLivedThreadLocals, Map<CentralizedThreadLocal<?>, Object> shortLivedThreadLocals) {
        ThreadLocalMap threadLocalMap = _longLivedThreadLocals.get();
        for (Map.Entry<CentralizedThreadLocal<?>, Object> entry : longLivedThreadLocals.entrySet()) {
            threadLocalMap.putEntry(entry.getKey(), entry.getValue());
        }
        threadLocalMap = _shortLivedThreadLocals.get();
        for (Map.Entry<CentralizedThreadLocal<?>, Object> entry : shortLivedThreadLocals.entrySet()) {
            threadLocalMap.putEntry(entry.getKey(), entry.getValue());
        }
    }

    public CentralizedThreadLocal(boolean shortLived) {
        this._shortLived = shortLived;
        this._hashCode = shortLived ? _shortLivedNextHasCode.getAndAdd(1640531527) : _longLivedNextHasCode.getAndAdd(1640531527);
    }

    @Override
    public T get() {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        Entry entry = threadLocalMap.getEntry(this);
        if (entry == null) {
            Object value = this.initialValue();
            threadLocalMap.putEntry(this, value);
            return value;
        }
        return (T)entry._value;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public void remove() {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        threadLocalMap.removeEntry(this);
    }

    @Override
    public void set(T value) {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        threadLocalMap.putEntry(this, value);
    }

    private static Map<CentralizedThreadLocal<?>, Object> _toMap(ThreadLocalMap threadLocalMap) {
        HashMap map = new HashMap(threadLocalMap._table.length);
        Entry[] entryArray = threadLocalMap._table;
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            map.put(entry._key, entry._value);
            ++n2;
        }
        return map;
    }

    private ThreadLocalMap _getThreadLocalMap() {
        if (this._shortLived) {
            return _shortLivedThreadLocals.get();
        }
        return _longLivedThreadLocals.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private CentralizedThreadLocal<?> _key;
        private Entry _next;
        private Object _value;

        public Entry(CentralizedThreadLocal<?> key, Object value, Entry next) {
            this._key = key;
            this._value = value;
            this._next = next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalMap {
        private static final int _INITIAL_CAPACITY = 16;
        private static final int _MAXIMUM_CAPACITY = 0x40000000;
        private int _size;
        private Entry[] _table = new Entry[16];
        private int _threshold = 10;

        private ThreadLocalMap() {
        }

        public void expand(int newCapacity) {
            if (this._table.length == 0x40000000) {
                this._threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] newTable = new Entry[newCapacity];
            int i = 0;
            while (i < this._table.length) {
                Entry entry = this._table[i];
                if (entry != null) {
                    Entry nextEntry;
                    this._table[i] = null;
                    do {
                        nextEntry = entry._next;
                        int index = ((CentralizedThreadLocal)entry._key)._hashCode & newCapacity - 1;
                        entry._next = newTable[index];
                        newTable[index] = entry;
                    } while ((entry = nextEntry) != null);
                }
                ++i;
            }
            this._table = newTable;
            this._threshold = newCapacity * 2 / 3;
        }

        /*
         * Unable to fully structure code
         */
        public Entry getEntry(CentralizedThreadLocal<?> key) {
            index = CentralizedThreadLocal.access$0(key) & this._table.length - 1;
            entry = this._table[index];
            if (entry == null) {
                return null;
            }
            if (Entry.access$1(entry) != key) ** GOTO lbl9
            return entry;
lbl-1000:
            // 1 sources

            {
                if (Entry.access$1(entry) != key) continue;
                return entry;
lbl9:
                // 2 sources

                ** while ((entry = Entry.access$0((Entry)entry)) != null)
            }
lbl10:
            // 1 sources

            return null;
        }

        public void putEntry(CentralizedThreadLocal<?> key, Object value) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry entry = this._table[index];
            while (entry != null) {
                if (entry._key == key) {
                    this._closeEntry(entry._value);
                    entry._value = value;
                    return;
                }
                entry = entry._next;
            }
            this._table[index] = new Entry(key, value, this._table[index]);
            if (this._size++ >= this._threshold) {
                this.expand(2 * this._table.length);
            }
        }

        public void closeEntries() {
            Entry[] entryArray = this._table;
            int n = this._table.length;
            int n2 = 0;
            while (n2 < n) {
                Entry entry = entryArray[n2];
                if (entry != null) {
                    this._closeEntry(entry._value);
                }
                ++n2;
            }
        }

        public void removeEntry(CentralizedThreadLocal<?> key) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry previousEntry = null;
            Entry entry = this._table[index];
            while (entry != null) {
                Entry nextEntry = entry._next;
                if (entry._key == key) {
                    --this._size;
                    this._closeEntry(entry._value);
                    if (previousEntry == null) {
                        this._table[index] = nextEntry;
                    } else {
                        previousEntry._next = nextEntry;
                    }
                    return;
                }
                previousEntry = entry;
                entry = nextEntry;
            }
        }

        protected void _closeEntry(Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Closeable) {
                Closeable closable = (Closeable)value;
                try {
                    closable.close();
                }
                catch (IOException ioe) {
                    _log.error(ioe, ioe);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalMapThreadLocal
    extends ThreadLocal<ThreadLocalMap> {
        private ThreadLocalMapThreadLocal() {
        }

        @Override
        protected ThreadLocalMap initialValue() {
            return new ThreadLocalMap();
        }

        @Override
        public void remove() {
            ThreadLocalMap threadLocalMap = (ThreadLocalMap)this.get();
            threadLocalMap.closeEntries();
            super.remove();
        }
    }
}

