/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodKey
implements Serializable {
    private String _className;
    private String _methodName;
    private Class<?>[] _parameterTypes;
    private String _toString;

    public MethodKey(Method method) {
        this(method.getDeclaringClass().getName(), method.getName(), method.getParameterTypes());
    }

    public MethodKey(String className, String methodName, Class<?> ... parameterTypes) {
        this._className = className;
        this._methodName = methodName;
        this._parameterTypes = parameterTypes;
    }

    public MethodKey(String className, String methodName, String[] parameterTypeNames) throws ClassNotFoundException {
        this._className = className;
        this._methodName = methodName;
        this._parameterTypes = new Class[parameterTypeNames.length];
        ClassLoader classLoader = null;
        if (parameterTypeNames.length > 0) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        int i = 0;
        while (i < parameterTypeNames.length) {
            String parameterTypeName = parameterTypeNames[i];
            this._parameterTypes[i] = Class.forName(parameterTypeName, true, classLoader);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        MethodKey methodKey = (MethodKey)obj;
        return this.toString().equals(methodKey.toString());
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this._parameterTypes;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._toString();
    }

    private String _toString() {
        if (this._toString == null) {
            if (this._parameterTypes != null && this._parameterTypes.length > 0) {
                StringBundler sb = new StringBundler(3 + this._parameterTypes.length);
                sb.append(this._className);
                sb.append(this._methodName);
                sb.append("-");
                Class<?>[] classArray = this._parameterTypes;
                int n = this._parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> parameterType = classArray[n2];
                    sb.append(parameterType.getName());
                    ++n2;
                }
                this._toString = sb.toString();
            } else {
                this._toString = this._className.concat(this._methodName);
            }
        }
        return this._toString;
    }
}

