/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

public class PrimitiveIntList {
    private int[] _elements;
    private int _elementsSize;

    public PrimitiveIntList() {
        this._elements = new int[10];
    }

    public PrimitiveIntList(int capacity) {
        this._elements = new int[capacity];
    }

    public void addAll(int[] values) {
        this._checkCapacity(this._elementsSize + values.length);
        System.arraycopy(values, 0, this._elements, this._elementsSize, values.length);
        this._elementsSize += values.length;
    }

    public void add(int value) {
        this._checkCapacity(this._elementsSize + 1);
        this._elements[this._elementsSize++] = value;
    }

    public int[] getArray() {
        this.trim();
        return this._elements;
    }

    public int size() {
        return this._elementsSize;
    }

    private void trim() {
        int oldSize = this._elements.length;
        if (this._elementsSize < oldSize) {
            int[] previousElements = this._elements;
            this._elements = new int[this._elementsSize];
            System.arraycopy(previousElements, 0, this._elements, 0, this._elementsSize);
        }
    }

    private void _checkCapacity(int minSize) {
        int oldSize = this._elements.length;
        if (minSize > oldSize) {
            int[] previousElements = this._elements;
            int newCapacity = oldSize * 3 / 2 + 1;
            if (newCapacity < minSize) {
                newCapacity = minSize;
            }
            this._elements = new int[newCapacity];
            System.arraycopy(previousElements, 0, this._elements, 0, this._elementsSize);
        }
    }
}

