/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.util.JavaProps;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SafeProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    private static Log _log = LogFactoryUtil.getLog(PropertiesUtil.class);
    private static Method _jdk6LoadMethod;

    static {
        if (JavaProps.isJDK6()) {
            try {
                _jdk6LoadMethod = ReflectionUtil.getDeclaredMethod(Properties.class, "load", Reader.class);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public static void copyProperties(Properties sourceProperties, Properties targetProperties) {
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            targetProperties.setProperty(key, value);
        }
    }

    public static Properties fromMap(Map<String, String> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static Properties fromMap(Properties properties) {
        return properties;
    }

    public static void fromProperties(Properties properties, Map<String, String> map) {
        map.clear();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties getProperties(Properties properties, String prefix, boolean removePrefix) {
        Properties subProperties = new Properties();
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = properties.getProperty(key);
            if (removePrefix) {
                key = key.substring(prefix.length());
            }
            subProperties.setProperty(key, value);
        }
        return subProperties;
    }

    public static String list(Map<String, String> map) {
        Properties properties = PropertiesUtil.fromMap(map);
        return PropertiesUtil.list(properties);
    }

    public static void list(Map<String, String> map, PrintStream printWriter) {
        Properties properties = PropertiesUtil.fromMap(map);
        properties.list(printWriter);
    }

    public static void list(Map<String, String> map, PrintWriter printWriter) {
        Properties properties = PropertiesUtil.fromMap(map);
        properties.list(printWriter);
    }

    public static String list(Properties properties) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        PrintStream printStream = new PrintStream(unsyncByteArrayOutputStream);
        properties.list(printStream);
        return unsyncByteArrayOutputStream.toString();
    }

    public static void load(Properties properties, String s) throws IOException {
        if (Validator.isNotNull(s)) {
            s = UnicodeFormatter.toString(s);
            s = StringUtil.replace(s, "\\u003d", "=");
            s = StringUtil.replace(s, "\\u000a", "\n");
            s = StringUtil.replace(s, "\\u0021", "!");
            s = StringUtil.replace(s, "\\u0023", "#");
            s = StringUtil.replace(s, "\\u0020", " ");
            s = StringUtil.replace(s, "\\u005c", "\\");
            properties.load(new UnsyncByteArrayInputStream(s.getBytes()));
            ArrayList<?> propertyNames = Collections.list(properties.propertyNames());
            int i = 0;
            while (i < propertyNames.size()) {
                String key = (String)propertyNames.get(i);
                String value = properties.getProperty(key);
                if (value != null) {
                    value = value.trim();
                    properties.setProperty(key, value);
                }
                ++i;
            }
        }
    }

    public static Properties load(String s) throws IOException {
        return PropertiesUtil.load(s, "UTF-8");
    }

    public static Properties load(String s, String charsetName) throws IOException {
        if (JavaProps.isJDK6()) {
            return PropertiesUtil.loadJDK6(new UnsyncStringReader(s));
        }
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode(charsetName, s);
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        return PropertiesUtil.loadJDK5(is, charsetName);
    }

    public static Properties load(InputStream is, String charsetName) throws IOException {
        if (JavaProps.isJDK6()) {
            return PropertiesUtil.loadJDK6(new InputStreamReader(is, charsetName));
        }
        return PropertiesUtil.loadJDK5(is, charsetName);
    }

    public static Properties loadJDK5(InputStream is, String charsetName) throws IOException {
        Properties iso8859_1Properties = new Properties();
        iso8859_1Properties.load(is);
        Properties properties = new Properties();
        CharsetEncoder charsetEncoder = CharsetEncoderUtil.getCharsetEncoder("ISO-8859-1");
        CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder(charsetName);
        for (Map.Entry<Object, Object> entry : iso8859_1Properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            key = charsetDecoder.decode(charsetEncoder.encode(CharBuffer.wrap(key))).toString();
            value = charsetDecoder.decode(charsetEncoder.encode(CharBuffer.wrap(value))).toString();
            properties.put(key, value);
        }
        return properties;
    }

    public static Properties loadJDK6(Reader reader) throws IOException {
        try {
            Properties properties = new Properties();
            _jdk6LoadMethod.invoke((Object)properties, reader);
            return properties;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IllegalStateException("Failed to invoke java.util.Properties.load(Reader reader)", e);
        }
    }

    public static void merge(Properties properties1, Properties properties2) {
        Enumeration<?> enu = properties2.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties2.getProperty(key);
            properties1.setProperty(key, value);
        }
    }

    public static String toString(Properties properties) {
        SafeProperties safeProperties = null;
        if (properties instanceof SafeProperties) {
            safeProperties = (SafeProperties)properties;
        }
        StringBundler sb = null;
        sb = properties.isEmpty() ? new StringBundler() : new StringBundler(properties.size() * 4);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            sb.append(key);
            sb.append("=");
            if (safeProperties != null) {
                sb.append(safeProperties.getEncodedProperty(key));
            } else {
                sb.append(properties.getProperty(key));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void trimKeys(Properties properties) {
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            String trimmedKey = key.trim();
            if (key.equals(trimmedKey)) continue;
            properties.remove(key);
            properties.setProperty(trimmedKey, value);
        }
    }
}

