/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReferenceEntry;
import java.lang.reflect.Field;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceRegistry {
    private static Log _log = LogFactoryUtil.getLog(ReferenceRegistry.class);
    private static Set<ReferenceEntry> _referenceEntries = new ConcurrentHashSet<ReferenceEntry>();

    public static void registerReference(Class<?> clazz, Object object, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            _referenceEntries.add(new ReferenceEntry(object, field));
        }
        catch (Exception e) {
            _log.error("Failed the get field " + fieldName + " for class " + clazz, e);
        }
    }

    public static void registerReference(Class<?> clazz, String fieldName) {
        ReferenceRegistry.registerReference(clazz, null, fieldName);
    }

    public static void registerReference(Field field) {
        _referenceEntries.add(new ReferenceEntry(field));
    }

    public static void registerReference(Object object, Field field) {
        _referenceEntries.add(new ReferenceEntry(object, field));
    }

    public static void releaseReferences() {
        for (ReferenceEntry referenceEntry : _referenceEntries) {
            try {
                referenceEntry.setValue(null);
            }
            catch (Exception e) {
                _log.error("Failed to release reference for " + referenceEntry, e);
            }
        }
        _referenceEntries.clear();
    }
}

