/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ResourceBundleThreadLocal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleUtil {
    public static final String NULL_VALUE = "NULL_VALUE";

    public static String getString(ResourceBundle resourceBundle, Locale locale, String key, Object[] arguments) {
        String value = ResourceBundleUtil.getString(resourceBundle, key);
        if (value == null) {
            return null;
        }
        if (arguments != null && arguments.length > 0) {
            MessageFormat messageFormat = new MessageFormat(value, locale);
            value = messageFormat.format(arguments);
        }
        return value;
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        ResourceBundleThreadLocal.setReplace(true);
        String value = null;
        try {
            value = resourceBundle.getString(key);
        }
        finally {
            ResourceBundleThreadLocal.setReplace(false);
        }
        if (NULL_VALUE.equals(value)) {
            value = null;
        }
        return value;
    }
}

