/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringEncoder;
import com.liferay.portal.kernel.util.StringParserFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParser {
    private static Pattern _escapeRegexPattern = Pattern.compile("[\\{\\}\\(\\)\\[\\]\\*\\+\\?\\$\\^\\.\\#\\\\]");
    private static Pattern _fragmentPattern = Pattern.compile("\\{.+?\\}");
    private String _builder;
    private StringEncoder _stringEncoder;
    private List<StringParserFragment> _stringParserFragments = new ArrayList<StringParserFragment>();
    private Pattern _pattern;

    public StringParser(String pattern) {
        this._builder = pattern;
        String regex = StringParser.escapeRegex(pattern);
        Matcher matcher = _fragmentPattern.matcher(pattern);
        while (matcher.find()) {
            String chunk = matcher.group();
            StringParserFragment stringParserFragment = new StringParserFragment(chunk);
            this._stringParserFragments.add(stringParserFragment);
            this._builder = this._builder.replace(chunk, stringParserFragment.getToken());
            regex = regex.replace(StringParser.escapeRegex(chunk), "(".concat(stringParserFragment.getPattern().concat(")")));
        }
        this._pattern = Pattern.compile(regex);
    }

    public String build(Map<String, String> parameters) {
        String s = this._builder;
        for (StringParserFragment stringParserFragment : this._stringParserFragments) {
            String value = parameters.get(stringParserFragment.getName());
            if (value == null) {
                return null;
            }
            if (this._stringEncoder != null && !stringParserFragment.isRaw()) {
                value = this._stringEncoder.encode(value);
            }
            if (!stringParserFragment.matches(value)) {
                return null;
            }
            s = s.replace(stringParserFragment.getToken(), value);
        }
        for (StringParserFragment stringParserFragment : this._stringParserFragments) {
            parameters.remove(stringParserFragment.getName());
        }
        return s;
    }

    public static String escapeRegex(String s) {
        Matcher matcher = _escapeRegexPattern.matcher(s);
        return matcher.replaceAll("\\\\$0");
    }

    public boolean parse(String s, Map<String, String> parameters) {
        Matcher matcher = this._pattern.matcher(s);
        if (!matcher.matches()) {
            return false;
        }
        int i = 1;
        while (i <= this._stringParserFragments.size()) {
            StringParserFragment stringParserFragment = this._stringParserFragments.get(i - 1);
            String value = matcher.group(i);
            if (this._stringEncoder != null && !stringParserFragment.isRaw()) {
                value = this._stringEncoder.decode(value);
            }
            parameters.put(stringParserFragment.getName(), value);
            ++i;
        }
        return true;
    }

    public void setStringEncoder(StringEncoder stringEncoder) {
        this._stringEncoder = stringEncoder;
    }
}

