/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.util.PortalUtil;
import java.net.URL;
import javax.servlet.ServletContext;

public class ThemeHelper {
    public static final String TEMPLATE_EXTENSION_FTL = "ftl";
    public static final String TEMPLATE_EXTENSION_VM = "vm";

    public static String getResourcePath(ServletContext servletContext, Theme theme, String portletId, String path) {
        StringBundler sb = new StringBundler(9);
        String themeContextName = GetterUtil.getString(theme.getServletContextName());
        sb.append(themeContextName);
        String servletContextName = "";
        String contextPath = ContextPathUtil.getContextPath(servletContext);
        if (!contextPath.equals(PortalUtil.getPathContext())) {
            servletContextName = GetterUtil.getString(servletContext.getServletContextName());
        }
        int start = 0;
        if (path.startsWith("/")) {
            start = 1;
        }
        int end = path.lastIndexOf(46);
        String extension = theme.getTemplateExtension();
        if (extension.equals(TEMPLATE_EXTENSION_FTL)) {
            sb.append(theme.getFreeMarkerTemplateLoader());
            sb.append(theme.getTemplatesPath());
            if (Validator.isNotNull(servletContextName) && !path.startsWith("/".concat(servletContextName))) {
                sb.append("/");
                sb.append(servletContextName);
            }
            sb.append("/");
            sb.append(path.substring(start, end));
            sb.append(".");
            if (Validator.isNotNull(portletId)) {
                sb.append(portletId);
                sb.append(".");
            }
            sb.append(TEMPLATE_EXTENSION_FTL);
            return sb.toString();
        }
        if (extension.equals(TEMPLATE_EXTENSION_VM)) {
            sb.append(theme.getVelocityResourceListener());
            sb.append(theme.getTemplatesPath());
            if (Validator.isNotNull(servletContextName) && !path.startsWith("/".concat(servletContextName))) {
                sb.append("/");
                sb.append(servletContextName);
            }
            sb.append("/");
            sb.append(path.substring(start, end));
            sb.append(".");
            if (Validator.isNotNull(portletId)) {
                sb.append(portletId);
                sb.append(".");
            }
            sb.append(TEMPLATE_EXTENSION_VM);
            return sb.toString();
        }
        return path;
    }

    public static boolean resourceExists(ServletContext servletContext, Theme theme, String portletId, String path) throws Exception {
        Boolean exists = null;
        if (Validator.isNotNull(portletId)) {
            exists = ThemeHelper._resourceExists(servletContext, theme, portletId, path);
            if (!exists.booleanValue() && portletId.contains("_INSTANCE_")) {
                String rootPortletId = PortletConstants.getRootPortletId(portletId);
                exists = ThemeHelper._resourceExists(servletContext, theme, rootPortletId, path);
            }
            if (!exists.booleanValue()) {
                exists = ThemeHelper._resourceExists(servletContext, theme, null, path);
            }
        }
        if (exists == null) {
            exists = ThemeHelper._resourceExists(servletContext, theme, portletId, path);
        }
        return exists;
    }

    private static boolean _resourceExists(ServletContext servletContext, Theme theme, String portletId, String path) throws Exception {
        if (Validator.isNull(path)) {
            return false;
        }
        String resourcePath = ThemeHelper.getResourcePath(servletContext, theme, portletId, path);
        String extension = theme.getTemplateExtension();
        if (extension.equals(TEMPLATE_EXTENSION_FTL)) {
            return FreeMarkerEngineUtil.resourceExists(resourcePath);
        }
        if (extension.equals(TEMPLATE_EXTENSION_VM)) {
            return VelocityEngineUtil.resourceExists(resourcePath);
        }
        URL url = null;
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            url = themeServletContext.getResource(resourcePath);
        } else {
            url = servletContext.getResource(resourcePath);
        }
        return url != null;
    }
}

