/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import javax.portlet.PortletPreferences;

public class ServiceContextUtil {
    public static Object deserialize(JSONObject jsonObject) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(jsonObject.getLong("companyId"));
        serviceContext.setLayoutFullURL(jsonObject.getString("layoutFullURL"));
        serviceContext.setLayoutURL(jsonObject.getString("layoutURL"));
        serviceContext.setPathMain(jsonObject.getString("pathMain"));
        serviceContext.setPlid(jsonObject.getLong("plid"));
        serviceContext.setPortalURL(jsonObject.getString("portalURL"));
        serviceContext.setScopeGroupId(jsonObject.getLong("scopeGroupId"));
        serviceContext.setUserDisplayURL(jsonObject.getString("userDisplayURL"));
        serviceContext.setUserId(jsonObject.getLong("userId"));
        String[] groupPermissions = StringUtil.split(jsonObject.getString("groupPermissions"));
        String[] guestPermissions = StringUtil.split(jsonObject.getString("guestPermissions"));
        serviceContext.setAddGroupPermissions(jsonObject.getBoolean("addGroupPermissions"));
        serviceContext.setAddGuestPermissions(jsonObject.getBoolean("addGuestPermissions"));
        serviceContext.setGroupPermissions(groupPermissions);
        serviceContext.setGuestPermissions(guestPermissions);
        long[] assetCategoryIds = StringUtil.split(jsonObject.getString("assetCategoryIds"), 0L);
        String[] assetTagNames = StringUtil.split(jsonObject.getString("assetTagNames"));
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setWorkflowAction(jsonObject.getInt("workflowAction"));
        return serviceContext;
    }

    public static PortletPreferences getPortletPreferences(ServiceContext serviceContext) throws SystemException {
        if (serviceContext == null) {
            return null;
        }
        PortletPreferencesIds portletPreferencesIds = serviceContext.getPortletPreferencesIds();
        if (portletPreferencesIds == null) {
            return null;
        }
        return PortletPreferencesLocalServiceUtil.getPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }
}

