/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.ThemeSetting;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeDisplay
implements Serializable {
    private static Log _log = LogFactoryUtil.getLog(ThemeDisplay.class);
    private Account _account;
    private boolean _addSessionIdToURL;
    private String _cdnHost = "";
    private ColorScheme _colorScheme;
    private Company _company;
    private long _companyGroupId;
    private String _companyLogo = "";
    private int _companyLogoHeight;
    private int _companyLogoWidth;
    private Contact _contact;
    private String _controlPanelCategory = "";
    private User _defaultUser;
    private Device _device;
    private long _doAsGroupId = 0L;
    private String _doAsUserId = "";
    private String _doAsUserLanguageId = "";
    private boolean _facebook;
    private String _facebookCanvasPageURL;
    private boolean _freeformLayout;
    private boolean _i18n;
    private String _i18nLanguageId;
    private String _i18nPath;
    private boolean _includePortletCssJs;
    private boolean _includeServiceJs;
    private boolean _isolated;
    private String _languageId;
    private Layout _layout;
    private List<Layout> _layouts;
    private String _layoutSetLogo = "";
    private LayoutSet _layoutSet;
    private LayoutTypePortlet _layoutTypePortlet;
    private String _lifecycle;
    private boolean _lifecycleAction;
    private boolean _lifecycleRender;
    private boolean _lifecycleResource;
    private Locale _locale;
    private MDRRuleGroupInstance _mdrRuleGroupInstance;
    private Group _parentGroup;
    private long _parentGroupId;
    private String _pathApplet = "";
    private String _pathCms = "";
    private String _pathColorSchemeImages = "";
    private String _pathContext = "";
    private String _pathFlash = "";
    private String _pathFriendlyURLPrivateGroup = "";
    private String _pathFriendlyURLPrivateUser = "";
    private String _pathFriendlyURLPublic = "";
    private String _pathImage = "";
    private String _pathJavaScript = "";
    private String _pathMain = "";
    private String _pathSound = "";
    private String _pathThemeCss = "";
    private String _pathThemeImages = "";
    private String _pathThemeJavaScript = "";
    private String _pathThemeRoot = "";
    private String _pathThemeTemplates = "";
    private transient PermissionChecker _permissionChecker;
    private long _plid;
    private String _portalURL = "";
    private PortletDisplay _portletDisplay = new PortletDisplay();
    private String _realCompanyLogo = "";
    private int _realCompanyLogoHeight;
    private int _realCompanyLogoWidth;
    private User _realUser;
    private long _refererPlid;
    private Group _scopeGroup;
    private long _scopeGroupId;
    private boolean _secure;
    private String _serverName;
    private int _serverPort;
    private String _sessionId = "";
    private boolean _showAddContentIcon;
    private boolean _showAddContentIconPermission;
    private boolean _showControlPanelIcon;
    private boolean _showHomeIcon;
    private boolean _showLayoutTemplatesIcon;
    private boolean _showManageSiteMembershipsIcon;
    private boolean _showMyAccountIcon;
    private boolean _showPageCustomizationIcon;
    private boolean _showPageSettingsIcon;
    private boolean _showPortalIcon;
    private boolean _showSignInIcon;
    private boolean _showSignOutIcon;
    private boolean _showSiteContentIcon;
    private boolean _showSiteMapSettingsIcon;
    private boolean _showSiteSettingsIcon;
    private boolean _showStagingIcon;
    private boolean _signedIn;
    private boolean _stateExclusive;
    private boolean _stateMaximized;
    private boolean _statePopUp;
    private Theme _theme;
    private boolean _themeCssFastLoad;
    private boolean _themeImagesFastLoad;
    private boolean _themeJsBarebone;
    private boolean _themeJsFastLoad;
    private String _tilesContent = "";
    private boolean _tilesSelectable;
    private String _tilesTitle = "";
    private TimeZone _timeZone;
    private List<Layout> _unfilteredLayouts;
    private String _urlAddContent = "";
    private String _urlControlPanel = "";
    private String _urlCurrent = "";
    private String _urlHome = "";
    private String _urlLayoutTemplates = "";
    private transient PortletURL _urlManageSiteMemberships = null;
    private transient PortletURL _urlMyAccount = null;
    private transient PortletURL _urlPageSettings = null;
    private String _urlPortal = "";
    private transient PortletURL _urlPublishToLive = null;
    private String _urlSignIn = "";
    private String _urlSignOut = "";
    private String _urlSiteContent = "";
    private transient PortletURL _urlSiteMapSettings = null;
    private transient PortletURL _urlSiteSettings = null;
    private transient PortletURL _urlUpdateManager = null;
    private User _user;
    private boolean _widget;

    public ThemeDisplay() {
        if (_log.isDebugEnabled()) {
            _log.debug("Creating new instance " + this.hashCode());
        }
        this._portletDisplay.setThemeDisplay(this);
    }

    public Account getAccount() {
        return this._account;
    }

    public String getCDNHost() {
        return this._cdnHost;
    }

    public ColorScheme getColorScheme() {
        return this._colorScheme;
    }

    public String getColorSchemeId() {
        return this._colorScheme.getColorSchemeId();
    }

    public Company getCompany() {
        return this._company;
    }

    public long getCompanyGroupId() {
        return this._companyGroupId;
    }

    public long getCompanyId() {
        return this._company.getCompanyId();
    }

    public String getCompanyLogo() {
        return this._companyLogo;
    }

    public int getCompanyLogoHeight() {
        return this._companyLogoHeight;
    }

    public int getCompanyLogoWidth() {
        return this._companyLogoWidth;
    }

    public Contact getContact() {
        return this._contact;
    }

    public String getControlPanelCategory() {
        return this._controlPanelCategory;
    }

    public User getDefaultUser() throws PortalException, SystemException {
        if (this._defaultUser == null) {
            this._defaultUser = this._company.getDefaultUser();
        }
        return this._defaultUser;
    }

    public long getDefaultUserId() throws PortalException, SystemException {
        return this.getDefaultUser().getUserId();
    }

    public Device getDevice() {
        return this._device;
    }

    public long getDoAsGroupId() {
        return this._doAsGroupId;
    }

    public String getDoAsUserId() {
        return this._doAsUserId;
    }

    public String getDoAsUserLanguageId() {
        return this._doAsUserLanguageId;
    }

    public String getFacebookCanvasPageURL() {
        return this._facebookCanvasPageURL;
    }

    public String getI18nLanguageId() {
        return this._i18nLanguageId;
    }

    public String getI18nPath() {
        return this._i18nPath;
    }

    public String getLanguageId() {
        return this._languageId;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public List<Layout> getLayouts() {
        return this._layouts;
    }

    public LayoutSet getLayoutSet() {
        return this._layoutSet;
    }

    public String getLayoutSetLogo() {
        return this._layoutSetLogo;
    }

    public LayoutTypePortlet getLayoutTypePortlet() {
        return this._layoutTypePortlet;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public MDRRuleGroupInstance getMDRRuleGroupInstance() {
        return this._mdrRuleGroupInstance;
    }

    public Group getParentGroup() {
        return this._parentGroup;
    }

    public long getParentGroupId() {
        return this._parentGroupId;
    }

    public String getParentGroupName() throws PortalException, SystemException {
        if (this._parentGroup == null) {
            return "";
        }
        return this._parentGroup.getDescriptiveName();
    }

    public String getPathApplet() {
        return this._pathApplet;
    }

    public String getPathCms() {
        return this._pathCms;
    }

    public String getPathColorSchemeImages() {
        return this._pathColorSchemeImages;
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public String getPathFlash() {
        return this._pathFlash;
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public String getPathJavaScript() {
        return this._pathJavaScript;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public String getPathSound() {
        return this._pathSound;
    }

    public String getPathThemeCss() {
        return this._pathThemeCss;
    }

    public String getPathThemeImage() {
        return this.getPathThemeImages();
    }

    public String getPathThemeImages() {
        return this._pathThemeImages;
    }

    public String getPathThemeJavaScript() {
        return this._pathThemeJavaScript;
    }

    public String getPathThemeRoot() {
        return this._pathThemeRoot;
    }

    public String getPathThemeTemplates() {
        return this._pathThemeTemplates;
    }

    public PermissionChecker getPermissionChecker() {
        return this._permissionChecker;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortalURL() {
        return this._portalURL;
    }

    public PortletDisplay getPortletDisplay() {
        return this._portletDisplay;
    }

    public long getPortletGroupId() {
        return this.getScopeGroupId();
    }

    public String getRealCompanyLogo() {
        return this._realCompanyLogo;
    }

    public int getRealCompanyLogoHeight() {
        return this._realCompanyLogoHeight;
    }

    public int getRealCompanyLogoWidth() {
        return this._realCompanyLogoWidth;
    }

    public User getRealUser() {
        return this._realUser;
    }

    public long getRealUserId() {
        return this._realUser.getUserId();
    }

    public long getRefererPlid() {
        return this._refererPlid;
    }

    public Group getScopeGroup() {
        return this._scopeGroup;
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public String getScopeGroupName() throws PortalException, SystemException {
        if (this._scopeGroup == null) {
            return "";
        }
        return this._scopeGroup.getDescriptiveName();
    }

    public long getScopeGroupIdOrLiveGroupId() throws PortalException, SystemException {
        return StagingUtil.getLiveGroupId(this._scopeGroupId);
    }

    public Layout getScopeLayout() throws PortalException, SystemException {
        if (this._layout.hasScopeGroup()) {
            return this._layout;
        }
        if (this._scopeGroup.isLayout()) {
            return LayoutLocalServiceUtil.getLayout(this._scopeGroup.getClassPK());
        }
        return null;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public Theme getTheme() {
        return this._theme;
    }

    public String getThemeId() {
        return this._theme.getThemeId();
    }

    public String getThemeSetting(String key) {
        Theme theme = this.getTheme();
        String device = theme.getDevice();
        Layout layout = this.getLayout();
        return layout.getThemeSetting(key, device);
    }

    public Properties getThemeSettings() {
        Theme theme = this.getTheme();
        Properties properties = new Properties();
        Map<String, ThemeSetting> themeSettings = theme.getSettings();
        for (String key : themeSettings.keySet()) {
            ThemeSetting themeSetting = themeSettings.get(key);
            String value = null;
            value = themeSetting.isConfigurable() ? this.getThemeSetting(key) : themeSetting.getValue();
            if (value == null) continue;
            properties.put(key, value);
        }
        return properties;
    }

    public String getTilesContent() {
        return this._tilesContent;
    }

    public String getTilesTitle() {
        return this._tilesTitle;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public List<Layout> getUnfilteredLayouts() {
        return this._unfilteredLayouts;
    }

    public String getURLAddContent() {
        return this._urlAddContent;
    }

    public String getURLControlPanel() {
        return this._urlControlPanel;
    }

    public String getURLCurrent() {
        return this._urlCurrent;
    }

    public String getURLHome() {
        return this._urlHome;
    }

    public String getURLLayoutTemplates() {
        return this._urlLayoutTemplates;
    }

    public PortletURL getURLManageSiteMemberships() {
        return this._urlManageSiteMemberships;
    }

    public PortletURL getURLMyAccount() {
        return this._urlMyAccount;
    }

    public PortletURL getURLPageSettings() {
        return this._urlPageSettings;
    }

    public String getURLPortal() {
        return this._urlPortal;
    }

    public PortletURL getURLPublishToLive() {
        return this._urlPublishToLive;
    }

    public String getURLSignIn() {
        return this._urlSignIn;
    }

    public String getURLSignOut() {
        return this._urlSignOut;
    }

    public String getURLSiteContent() {
        return this._urlSiteContent;
    }

    public PortletURL getURLSiteMapSettings() {
        return this._urlSiteMapSettings;
    }

    public PortletURL getURLSiteSettings() {
        return this._urlSiteSettings;
    }

    public PortletURL getURLUpdateManager() {
        return this._urlUpdateManager;
    }

    public User getUser() {
        return this._user;
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public boolean isAddSessionIdToURL() {
        return this._addSessionIdToURL;
    }

    public boolean isFacebook() {
        return this._facebook;
    }

    public boolean isFreeformLayout() {
        return this._freeformLayout;
    }

    public boolean isI18n() {
        return this._i18n;
    }

    public boolean isImpersonated() {
        return this.getUserId() != this.getRealUserId();
    }

    public boolean isIncludedJs(String js) {
        String path = this.getPathJavaScript();
        if (this.isIncludePortletCssJs() && js.startsWith(String.valueOf(path) + "/liferay/portlet_css.js")) {
            return true;
        }
        return this.isIncludeServiceJs() && js.startsWith(String.valueOf(path) + "/liferay/service.js");
    }

    public boolean isIncludePortletCssJs() {
        return this._includePortletCssJs;
    }

    public boolean isIncludeServiceJs() {
        return this._includeServiceJs;
    }

    public boolean isIsolated() {
        return this._isolated;
    }

    public boolean isLifecycleAction() {
        return this._lifecycleAction;
    }

    public boolean isLifecycleRender() {
        return this._lifecycleRender;
    }

    public boolean isLifecycleResource() {
        return this._lifecycleResource;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public boolean isShowAddContentIcon() {
        return this._showAddContentIcon;
    }

    public boolean isShowAddContentIconPermission() {
        return this._showAddContentIconPermission;
    }

    public boolean isShowControlPanelIcon() {
        return this._showControlPanelIcon;
    }

    public boolean isShowHomeIcon() {
        return this._showHomeIcon;
    }

    public boolean isShowLayoutTemplatesIcon() {
        return this._showLayoutTemplatesIcon;
    }

    public boolean isShowManageSiteMembershipsIcon() {
        return this._showManageSiteMembershipsIcon;
    }

    public boolean isShowMyAccountIcon() {
        return this._showMyAccountIcon;
    }

    public boolean isShowPageCustomizationIcon() {
        return this._showPageCustomizationIcon;
    }

    public boolean isShowPageSettingsIcon() {
        return this._showPageSettingsIcon;
    }

    public boolean isShowPortalIcon() {
        return this._showPortalIcon;
    }

    public boolean isShowSignInIcon() {
        return this._showSignInIcon;
    }

    public boolean isShowSignOutIcon() {
        return this._showSignOutIcon;
    }

    public boolean isShowSiteContentIcon() {
        return this._showSiteContentIcon;
    }

    public boolean isShowSiteMapSettingsIcon() {
        return this._showSiteMapSettingsIcon;
    }

    public boolean isShowSiteSettingsIcon() {
        return this._showSiteSettingsIcon;
    }

    public boolean isShowStagingIcon() {
        return this._showStagingIcon;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    public boolean isStateExclusive() {
        return this._stateExclusive;
    }

    public boolean isStateMaximized() {
        return this._stateMaximized;
    }

    public boolean isStatePopUp() {
        return this._statePopUp;
    }

    public boolean isThemeCssFastLoad() {
        return this._themeCssFastLoad;
    }

    public boolean isThemeImagesFastLoad() {
        return this._themeImagesFastLoad;
    }

    public boolean isThemeJsBarebone() {
        return this._themeJsBarebone;
    }

    public boolean isThemeJsFastLoad() {
        return this._themeJsFastLoad;
    }

    public boolean isTilesSelectable() {
        return this._tilesSelectable;
    }

    public boolean isWapTheme() {
        return this._theme.isWapTheme();
    }

    public boolean isWidget() {
        return this._widget;
    }

    public void setAccount(Account account) {
        this._account = account;
    }

    public void setAddSessionIdToURL(boolean addSessionIdToURL) {
        this._addSessionIdToURL = addSessionIdToURL;
    }

    public void setCDNHost(String cdnHost) {
        this._cdnHost = cdnHost;
    }

    public void setCompany(Company company) throws PortalException, SystemException {
        this._company = company;
        this._companyGroupId = company.getGroup().getGroupId();
        this.setAccount(company.getAccount());
    }

    public void setCompanyLogo(String companyLogo) {
        this._companyLogo = companyLogo;
    }

    public void setCompanyLogoHeight(int companyLogoHeight) {
        this._companyLogoHeight = companyLogoHeight;
    }

    public void setCompanyLogoWidth(int companyLogoWidth) {
        this._companyLogoWidth = companyLogoWidth;
    }

    public void setContact(Contact contact) {
        this._contact = contact;
    }

    public void setControlPanelCategory(String controlPanelCategory) {
        this._controlPanelCategory = controlPanelCategory;
    }

    public void setDevice(Device device) {
        this._device = device;
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
    }

    public void setDoAsUserId(String doAsUserId) {
        this._doAsUserId = doAsUserId;
    }

    public void setDoAsUserLanguageId(String doAsUserLanguageId) {
        this._doAsUserLanguageId = doAsUserLanguageId;
    }

    public void setFacebookCanvasPageURL(String facebookCanvasPageURL) {
        this._facebookCanvasPageURL = facebookCanvasPageURL;
        if (Validator.isNotNull(facebookCanvasPageURL)) {
            this._facebook = true;
        }
    }

    public void setFreeformLayout(boolean freeformLayout) {
        this._freeformLayout = freeformLayout;
    }

    public void setI18nLanguageId(String i18nLanguageId) {
        this._i18nLanguageId = i18nLanguageId;
        this._i18n = Validator.isNotNull(i18nLanguageId);
    }

    public void setI18nPath(String i18nPath) {
        this._i18nPath = i18nPath;
        this._i18n = Validator.isNotNull(i18nPath);
    }

    public void setIncludePortletCssJs(boolean includePortletCssJs) {
        this._includePortletCssJs = includePortletCssJs;
    }

    public void setIncludeServiceJs(boolean includeServiceJs) {
        this._includeServiceJs = includeServiceJs;
    }

    public void setIsolated(boolean isolated) {
        this._isolated = isolated;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    public void setLayout(Layout layout) {
        this._layout = layout;
    }

    public void setLayouts(List<Layout> layouts) {
        this._layouts = layouts;
    }

    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    public void setLayoutSetLogo(String layoutSetLogo) {
        this._layoutSetLogo = layoutSetLogo;
    }

    public void setLayoutTypePortlet(LayoutTypePortlet layoutTypePortlet) {
        this._layoutTypePortlet = layoutTypePortlet;
    }

    public void setLifecycle(String lifecycle) {
        this._lifecycle = lifecycle;
    }

    public void setLifecycleAction(boolean lifecycleAction) {
        this._lifecycleAction = lifecycleAction;
    }

    public void setLifecycleRender(boolean lifecycleRender) {
        this._lifecycleRender = lifecycleRender;
    }

    public void setLifecycleResource(boolean lifecycleResource) {
        this._lifecycleResource = lifecycleResource;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        LocaleThreadLocal.setThemeDisplayLocale(locale);
    }

    public void setLookAndFeel(Theme theme, ColorScheme colorScheme) {
        this._theme = theme;
        this._colorScheme = colorScheme;
        if (theme != null && colorScheme != null) {
            String themeStaticResourcePath = theme.getStaticResourcePath();
            String host = this.getCDNHost();
            if (Validator.isNull(host) && this.isFacebook()) {
                host = this.getPortalURL();
            }
            this.setPathColorSchemeImages(String.valueOf(host) + themeStaticResourcePath + colorScheme.getColorSchemeImagesPath());
            this.setPathThemeCss(String.valueOf(host) + themeStaticResourcePath + theme.getCssPath());
            this.setPathThemeImages(String.valueOf(host) + themeStaticResourcePath + theme.getImagesPath());
            this.setPathThemeJavaScript(String.valueOf(host) + themeStaticResourcePath + theme.getJavaScriptPath());
            this.setPathThemeRoot(String.valueOf(themeStaticResourcePath) + theme.getRootPath());
            this.setPathThemeTemplates(String.valueOf(host) + themeStaticResourcePath + theme.getTemplatesPath());
        }
    }

    public void setMDRRuleGroupInstance(MDRRuleGroupInstance mdrRuleGroupInstance) {
        this._mdrRuleGroupInstance = mdrRuleGroupInstance;
    }

    public void setParentGroupId(long parentGroupId) {
        this._parentGroupId = parentGroupId;
        if (this._parentGroupId > 0L) {
            try {
                this._parentGroup = GroupLocalServiceUtil.getGroup(this._parentGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public void setPathApplet(String pathApplet) {
        this._pathApplet = pathApplet;
    }

    public void setPathCms(String pathCms) {
        this._pathCms = pathCms;
    }

    public void setPathColorSchemeImages(String pathColorSchemeImages) {
        this._pathColorSchemeImages = pathColorSchemeImages;
    }

    public void setPathContext(String pathContext) {
        this._pathContext = pathContext;
    }

    public void setPathFlash(String pathFlash) {
        this._pathFlash = pathFlash;
    }

    public void setPathFriendlyURLPrivateGroup(String pathFriendlyURLPrivateGroup) {
        this._pathFriendlyURLPrivateGroup = pathFriendlyURLPrivateGroup;
    }

    public void setPathFriendlyURLPrivateUser(String pathFriendlyURLPrivateUser) {
        this._pathFriendlyURLPrivateUser = pathFriendlyURLPrivateUser;
    }

    public void setPathFriendlyURLPublic(String pathFriendlyURLPublic) {
        this._pathFriendlyURLPublic = pathFriendlyURLPublic;
    }

    public void setPathImage(String pathImage) {
        if (this.isFacebook() && !pathImage.startsWith("http://") && !pathImage.startsWith("https://")) {
            pathImage = String.valueOf(this.getPortalURL()) + pathImage;
        }
        this._pathImage = pathImage;
    }

    public void setPathJavaScript(String pathJavaScript) {
        this._pathJavaScript = pathJavaScript;
    }

    public void setPathMain(String pathMain) {
        this._pathMain = pathMain;
    }

    public void setPathSound(String pathSound) {
        this._pathSound = pathSound;
    }

    public void setPathThemeCss(String pathThemeCss) {
        this._pathThemeCss = pathThemeCss;
    }

    public void setPathThemeImages(String pathThemeImages) {
        this._pathThemeImages = pathThemeImages;
    }

    public void setPathThemeJavaScript(String pathThemeJavaScript) {
        this._pathThemeJavaScript = pathThemeJavaScript;
    }

    public void setPathThemeRoot(String pathThemeRoot) {
        this._pathThemeRoot = pathThemeRoot;
    }

    public void setPathThemeTemplates(String pathThemeTemplates) {
        this._pathThemeTemplates = pathThemeTemplates;
    }

    public void setPermissionChecker(PermissionChecker permissionChecker) {
        this._permissionChecker = permissionChecker;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortalURL(String portalURL) {
        this._portalURL = portalURL;
    }

    public void setRealCompanyLogo(String realCompanyLogo) {
        this._realCompanyLogo = realCompanyLogo;
    }

    public void setRealCompanyLogoHeight(int realCompanyLogoHeight) {
        this._realCompanyLogoHeight = realCompanyLogoHeight;
    }

    public void setRealCompanyLogoWidth(int realCompanyLogoWidth) {
        this._realCompanyLogoWidth = realCompanyLogoWidth;
    }

    public void setRealUser(User realUser) {
        this._realUser = realUser;
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
        if (this._scopeGroupId > 0L) {
            try {
                this._scopeGroup = GroupLocalServiceUtil.getGroup(this._scopeGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    public void setShowAddContentIcon(boolean showAddContentIcon) {
        this._showAddContentIcon = showAddContentIcon;
    }

    public void setShowAddContentIconPermission(boolean showAddContentIconPermission) {
        this._showAddContentIconPermission = showAddContentIconPermission;
    }

    public void setShowControlPanelIcon(boolean showControlPanelIcon) {
        this._showControlPanelIcon = showControlPanelIcon;
    }

    public void setShowHomeIcon(boolean showHomeIcon) {
        this._showHomeIcon = showHomeIcon;
    }

    public void setShowLayoutTemplatesIcon(boolean showLayoutTemplatesIcon) {
        this._showLayoutTemplatesIcon = showLayoutTemplatesIcon;
    }

    public void setShowManageSiteMembershipsIcon(boolean showManageSiteMembershipsIcon) {
        this._showManageSiteMembershipsIcon = showManageSiteMembershipsIcon;
    }

    public void setShowMyAccountIcon(boolean showMyAccountIcon) {
        this._showMyAccountIcon = showMyAccountIcon;
    }

    public void setShowPageCustomizationIcon(boolean showPageCustomizationIcon) {
        this._showPageCustomizationIcon = showPageCustomizationIcon;
    }

    public void setShowPageSettingsIcon(boolean showPageSettingsIcon) {
        this._showPageSettingsIcon = showPageSettingsIcon;
    }

    public void setShowPortalIcon(boolean showPortalIcon) {
        this._showPortalIcon = showPortalIcon;
    }

    public void setShowSignInIcon(boolean showSignInIcon) {
        this._showSignInIcon = showSignInIcon;
    }

    public void setShowSignOutIcon(boolean showSignOutIcon) {
        this._showSignOutIcon = showSignOutIcon;
    }

    public void setShowSiteContentIcon(boolean showSiteContentIcon) {
        this._showSiteContentIcon = showSiteContentIcon;
    }

    public void setShowSiteMapSettingsIcon(boolean showSiteMapSettingsIcon) {
        this._showSiteMapSettingsIcon = showSiteMapSettingsIcon;
    }

    public void setShowSiteSettingsIcon(boolean showSiteSettingsIcon) {
        this._showSiteSettingsIcon = showSiteSettingsIcon;
    }

    public void setShowStagingIcon(boolean showStagingIcon) {
        this._showStagingIcon = showStagingIcon;
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setStateExclusive(boolean stateExclusive) {
        this._stateExclusive = stateExclusive;
    }

    public void setStateMaximized(boolean stateMaximized) {
        this._stateMaximized = stateMaximized;
    }

    public void setStatePopUp(boolean statePopUp) {
        this._statePopUp = statePopUp;
    }

    public void setThemeCssFastLoad(boolean themeCssFastLoad) {
        this._themeCssFastLoad = themeCssFastLoad;
    }

    public void setThemeImagesFastLoad(boolean themeImagesFastLoad) {
        this._themeImagesFastLoad = themeImagesFastLoad;
    }

    public void setThemeJsBarebone(boolean themeJsBarebone) {
        this._themeJsBarebone = themeJsBarebone;
    }

    public void setThemeJsFastLoad(boolean themeJsFastLoad) {
        this._themeJsFastLoad = themeJsFastLoad;
    }

    public void setTilesContent(String tilesContent) {
        this._tilesContent = tilesContent;
    }

    public void setTilesSelectable(boolean tilesSelectable) {
        this._tilesSelectable = tilesSelectable;
    }

    public void setTilesTitle(String tilesTitle) {
        this._tilesTitle = tilesTitle;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        TimeZoneThreadLocal.setThemeDisplayTimeZone(timeZone);
    }

    public void setUnfilteredLayouts(List<Layout> unfilteredLayouts) {
        this._unfilteredLayouts = unfilteredLayouts;
    }

    public void setURLAddContent(String urlAddContent) {
        this._urlAddContent = urlAddContent;
    }

    public void setURLControlPanel(String urlControlPanel) {
        this._urlControlPanel = urlControlPanel;
    }

    public void setURLCurrent(String urlCurrent) {
        this._urlCurrent = urlCurrent;
    }

    public void setURLHome(String urlHome) {
        this._urlHome = urlHome;
    }

    public void setURLLayoutTemplates(String urlLayoutTemplates) {
        this._urlLayoutTemplates = urlLayoutTemplates;
    }

    public void setURLManageSiteMemberships(PortletURL urlManageSiteMemberships) {
        this._urlManageSiteMemberships = urlManageSiteMemberships;
    }

    public void setURLMyAccount(PortletURL urlMyAccount) {
        this._urlMyAccount = urlMyAccount;
    }

    public void setURLPageSettings(PortletURL urlPageSettings) {
        this._urlPageSettings = urlPageSettings;
    }

    public void setURLPortal(String urlPortal) {
        this._urlPortal = urlPortal;
    }

    public void setURLPublishToLive(PortletURL urlPublishToLive) {
        this._urlPublishToLive = urlPublishToLive;
    }

    public void setURLSignIn(String urlSignIn) {
        this._urlSignIn = urlSignIn;
    }

    public void setURLSignOut(String urlSignOut) {
        this._urlSignOut = urlSignOut;
    }

    public void setURLSiteContent(String urlSiteContent) {
        this._urlSiteContent = urlSiteContent;
    }

    public void setURLSiteMapSettings(PortletURL urlSiteMapSettings) {
        this._urlSiteMapSettings = urlSiteMapSettings;
    }

    public void setURLSiteSettings(PortletURL urlSiteSettings) {
        this._urlSiteSettings = urlSiteSettings;
    }

    public void setURLUpdateManager(PortletURL urlUpdateManager) {
        this._urlUpdateManager = urlUpdateManager;
    }

    public void setUser(User user) throws PortalException, SystemException {
        this._user = user;
        this.setContact(user.getContact());
    }

    public void setWidget(boolean widget) {
        this._widget = widget;
    }

    public String translate(String key) {
        return LanguageUtil.get(this.getLocale(), key);
    }

    public String translate(String pattern, Object argument) {
        return LanguageUtil.format(this.getLocale(), pattern, argument);
    }

    public String translate(String pattern, Object[] arguments) {
        return LanguageUtil.format(this.getLocale(), pattern, arguments);
    }
}

