/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.model.Group;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ControlPanelEntry;

public abstract class BaseControlPanelEntry
implements ControlPanelEntry {
    public boolean isVisible(Portlet portlet, String category, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group group = themeDisplay.getScopeGroup();
        long plid = 0L;
        if (category.equals("content") && (plid = group.getDefaultPublicPlid()) == 0L) {
            plid = group.getDefaultPrivatePlid();
        }
        if (category.equals("content") && permissionChecker.isGroupAdmin(group.getGroupId()) && !group.isUser()) {
            return true;
        }
        long groupId = group.getGroupId();
        if (category.equals("portal") || category.equals("server")) {
            groupId = 0L;
        }
        if (PortletPermissionUtil.contains(permissionChecker, groupId, plid, portlet.getPortletId(), "ACCESS_IN_CONTROL_PANEL", true)) {
            return true;
        }
        return this.isVisible(themeDisplay.getPermissionChecker(), portlet);
    }
}

