/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.FileFilter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;

public abstract class DLPreviewableProcessor
implements DLProcessor {
    public static final String PREVIEW_PATH = "document_preview/";
    public static final String PREVIEW_TMP_PATH = String.valueOf(SystemProperties.get("java.io.tmpdir")) + "/liferay/" + "document_preview/";
    public static final long REPOSITORY_ID = 0L;
    public static int THUMBNAIL_INDEX_CUSTOM_1 = 1;
    public static int THUMBNAIL_INDEX_CUSTOM_2 = 2;
    public static int THUMBNAIL_INDEX_DEFAULT = 0;
    public static final String THUMBNAIL_PATH = "document_thumbnail/";
    public static final String THUMBNAIL_TMP_PATH = String.valueOf(SystemProperties.get("java.io.tmpdir")) + "/liferay/" + "document_thumbnail/";
    private static Log _log = LogFactoryUtil.getLog(DLPreviewableProcessor.class);

    public static void deleteFiles() {
        long[] companyIds;
        long[] lArray = companyIds = PortalUtil.getCompanyIds();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            try {
                DLStoreUtil.deleteDirectory(companyId, 0L, PREVIEW_PATH);
            }
            catch (Exception exception) {}
            try {
                DLStoreUtil.deleteDirectory(companyId, 0L, THUMBNAIL_PATH);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public static void deleteFiles(FileEntry fileEntry, String thumbnailType) {
        DLPreviewableProcessor.deleteFiles(fileEntry.getCompanyId(), fileEntry.getRepositoryId(), fileEntry.getFileEntryId(), -1L, thumbnailType);
    }

    public static void deleteFiles(FileVersion fileVersion, String thumbnailType) {
        DLPreviewableProcessor.deleteFiles(fileVersion.getCompanyId(), fileVersion.getRepositoryId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), thumbnailType);
    }

    protected static void deleteFiles(long companyId, long groupId, long fileEntryId, long fileVersionId, String thumbnailType) {
        try {
            DLStoreUtil.deleteDirectory(companyId, 0L, DLPreviewableProcessor.getPathSegment(groupId, fileEntryId, fileVersionId, true));
        }
        catch (Exception exception) {}
        try {
            String dirName = DLPreviewableProcessor.getPathSegment(groupId, fileEntryId, fileVersionId, false);
            if (fileVersionId > 0L) {
                dirName = dirName.concat(".");
                dirName = dirName.concat(thumbnailType);
            }
            DLStoreUtil.deleteDirectory(companyId, 0L, dirName);
        }
        catch (Exception exception) {}
    }

    protected static String getPathSegment(FileVersion fileVersion, boolean preview) {
        return DLPreviewableProcessor.getPathSegment(fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), preview);
    }

    protected static String getPathSegment(long groupId, long fileEntryId, long fileVersionId, boolean preview) {
        StringBundler sb = null;
        sb = fileVersionId > 0L ? new StringBundler(5) : new StringBundler(3);
        if (preview) {
            sb.append(PREVIEW_PATH);
        } else {
            sb.append(THUMBNAIL_PATH);
        }
        sb.append(groupId);
        sb.append(DLUtil.getDividedPath(fileEntryId));
        if (fileVersionId > 0L) {
            sb.append("/");
            sb.append(fileVersionId);
        }
        return sb.toString();
    }

    public boolean isSupported(FileVersion fileVersion) {
        if (fileVersion == null) {
            return false;
        }
        return this.isSupported(fileVersion.getMimeType());
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, File srcFile) throws Exception {
        try {
            DLStoreUtil.addDirectory(companyId, 0L, dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        DLStoreUtil.addFile(companyId, 0L, filePath, srcFile);
    }

    protected InputStream doGetPreviewAsStream(FileVersion fileVersion, int index, String type) throws Exception {
        return DLStoreUtil.getFileAsStream(fileVersion.getCompanyId(), 0L, this.getPreviewFilePath(fileVersion, index, type));
    }

    protected InputStream doGetPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, 0, type);
    }

    protected int doGetPreviewFileCount(FileVersion fileVersion) throws Exception {
        try {
            String[] fileNames = DLStoreUtil.getFileNames(fileVersion.getCompanyId(), 0L, DLPreviewableProcessor.getPathSegment(fileVersion, true));
            return fileNames.length;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, int index, String type) throws Exception {
        return DLStoreUtil.getFileSize(fileVersion.getCompanyId(), 0L, this.getPreviewFilePath(fileVersion, index, type));
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, 0, type);
    }

    protected InputStream doGetThumbnailAsStream(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        String type = this.getThumbnailType(fileVersion);
        return DLStoreUtil.getFileAsStream(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, type, thumbnailIndex));
    }

    protected long doGetThumbnailFileSize(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        String type = this.getThumbnailType(fileVersion);
        return DLStoreUtil.getFileSize(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, type, thumbnailIndex));
    }

    protected String getPreviewFilePath(FileVersion fileVersion, int index, String type) {
        StringBundler sb = null;
        sb = index > 0 ? new StringBundler(5) : new StringBundler(3);
        sb.append(DLPreviewableProcessor.getPathSegment(fileVersion, true));
        if (index > 0) {
            sb.append("/");
            sb.append(index - 1);
        }
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected String getPreviewFilePath(FileVersion fileVersion, String type) {
        return this.getPreviewFilePath(fileVersion, 0, type);
    }

    protected File getPreviewTempFile(String id, int index, String type) {
        String previewTempFilePath = this.getPreviewTempFilePath(id, index, type);
        return new File(previewTempFilePath);
    }

    protected File getPreviewTempFile(String id, String type) {
        return this.getPreviewTempFile(id, 0, type);
    }

    protected int getPreviewTempFileCount(FileVersion fileVersion, String type) {
        String tempFileId = DLUtil.getTempFileId(fileVersion.getFileEntryId(), fileVersion.getVersion());
        StringBundler sb = new StringBundler(5);
        sb.append(tempFileId);
        sb.append("-");
        sb.append("(.*)");
        sb.append(".");
        sb.append(type);
        File dir = new File(PREVIEW_TMP_PATH);
        File[] files = dir.listFiles(new FileFilter(sb.toString()));
        if (_log.isDebugEnabled()) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                _log.debug("Preview page for " + tempFileId + " " + file);
                ++n2;
            }
        }
        return files.length;
    }

    protected String getPreviewTempFilePath(String id, int index, String type) {
        StringBundler sb = null;
        sb = index > 0 ? new StringBundler(6) : new StringBundler(4);
        sb.append(PREVIEW_TMP_PATH);
        sb.append(id);
        if (index > 0) {
            sb.append("-");
            sb.append(index - 1);
        }
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected String getPreviewTempFilePath(String id, String type) {
        return this.getPreviewTempFilePath(id, 0, type);
    }

    protected abstract String getPreviewType(FileVersion var1);

    protected String getThumbnailFilePath(FileVersion fileVersion, String type, int index) {
        StringBundler sb = new StringBundler(5);
        sb.append(DLPreviewableProcessor.getPathSegment(fileVersion, false));
        if (index != THUMBNAIL_INDEX_DEFAULT) {
            sb.append("-");
            sb.append(index);
        }
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected File getThumbnailTempFile(String id, String type) {
        String thumbnailTempFilePath = this.getThumbnailTempFilePath(id, type);
        return new File(thumbnailTempFilePath);
    }

    protected String getThumbnailTempFilePath(String id, String type) {
        StringBundler sb = new StringBundler(4);
        sb.append(THUMBNAIL_TMP_PATH);
        sb.append(id);
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected abstract String getThumbnailType(FileVersion var1);

    protected boolean hasThumbnail(FileVersion fileVersion, int thumbnailIndex) {
        try {
            String imageType = this.getThumbnailType(fileVersion);
            return DLStoreUtil.hasFile(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, imageType, thumbnailIndex));
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    protected boolean isCustomThumbnailsEnabled(int thumbnailIndex) throws Exception {
        return thumbnailIndex == 1 ? PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom1.max.height") > 0 || PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom1.max.width") > 0 : thumbnailIndex == 2 && (PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom2.max.height") > 0 || PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom2.max.width") > 0);
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        ImageBag imageBag = ImageToolUtil.read(file);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        this.storeThumbnailImages(fileVersion, renderedImage);
    }

    protected void storeThumbnailImages(FileVersion fileVersion, RenderedImage renderedImage) throws Exception {
        this.storeThumbnailmage(fileVersion, renderedImage, THUMBNAIL_INDEX_DEFAULT);
        this.storeThumbnailmage(fileVersion, renderedImage, THUMBNAIL_INDEX_CUSTOM_1);
        this.storeThumbnailmage(fileVersion, renderedImage, THUMBNAIL_INDEX_CUSTOM_2);
    }

    protected void storeThumbnailmage(FileVersion fileVersion, RenderedImage renderedImage, int thumbnailIndex) throws Exception {
        if (thumbnailIndex > 0 && !this.isCustomThumbnailsEnabled(thumbnailIndex)) {
            return;
        }
        String type = this.getThumbnailType(fileVersion);
        String maxHeightPropsKey = "dl.file.entry.thumbnail.max.height";
        if (thumbnailIndex == THUMBNAIL_INDEX_CUSTOM_1) {
            maxHeightPropsKey = "dl.file.entry.thumbnail.custom1.max.height";
        } else if (thumbnailIndex == THUMBNAIL_INDEX_CUSTOM_2) {
            maxHeightPropsKey = "dl.file.entry.thumbnail.custom2.max.height";
        }
        String maxWidthPropsKey = "dl.file.entry.thumbnail.max.width";
        if (thumbnailIndex == THUMBNAIL_INDEX_CUSTOM_1) {
            maxWidthPropsKey = "dl.file.entry.thumbnail.custom1.max.width";
        } else if (thumbnailIndex == THUMBNAIL_INDEX_CUSTOM_2) {
            maxWidthPropsKey = "dl.file.entry.thumbnail.custom2.max.width";
        }
        RenderedImage thumbnailRenderedImage = ImageToolUtil.scale(renderedImage, PrefsPropsUtil.getInteger(maxHeightPropsKey), PrefsPropsUtil.getInteger(maxWidthPropsKey));
        byte[] bytes = ImageToolUtil.getBytes(thumbnailRenderedImage, MimeTypesUtil.getContentType("A." + type));
        File file = FileUtil.createTempFile(bytes);
        try {
            this.addFileToStore(fileVersion.getCompanyId(), THUMBNAIL_PATH, this.getThumbnailFilePath(fileVersion, type, thumbnailIndex), file);
        }
        finally {
            FileUtil.delete(file);
        }
    }
}

