/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util.comparator;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import java.util.Date;

public class RepositoryModelModifiedDateComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "modifiedDate ASC";
    public static final String ORDER_BY_DESC = "modifiedDate DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"modifiedDate"};
    private boolean _ascending;

    public RepositoryModelModifiedDateComparator() {
        this(false);
    }

    public RepositoryModelModifiedDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        Date modifiedDate1 = this.getModifiedDate(obj1);
        Date modifiedDate2 = this.getModifiedDate(obj2);
        int value = DateUtil.compareTo(modifiedDate1, modifiedDate2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected Date getModifiedDate(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getModifiedDate();
        }
        if (obj instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)obj;
            return dlFileShortcut.getModifiedDate();
        }
        if (obj instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)obj;
            return dlFolder.getModifiedDate();
        }
        if (obj instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)obj;
            return fileEntry.getModifiedDate();
        }
        Folder folder = (Folder)obj;
        return folder.getModifiedDate();
    }
}

