/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util.comparator;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;

public class RepositoryModelNameComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "title ASC";
    public static final String ORDER_BY_DESC = "title DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"title"};
    private boolean _ascending;

    public RepositoryModelNameComparator() {
        this(false);
    }

    public RepositoryModelNameComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        String name1 = this.getName(obj1);
        String name2 = this.getName(obj2);
        int value = name1.compareToIgnoreCase(name2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected String getName(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getTitle();
        }
        if (obj instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)obj;
            return dlFileShortcut.getToTitle();
        }
        if (obj instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)obj;
            return dlFolder.getName();
        }
        if (obj instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)obj;
            return fileEntry.getTitle();
        }
        Folder folder = (Folder)obj;
        return folder.getName();
    }
}

