/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portlet.dynamicdatalists.util.DDLExportFormat;
import com.liferay.portlet.dynamicdatalists.util.DDLExporter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLExporterFactory {
    public static Map<DDLExportFormat, DDLExporter> _exporters;

    public static DDLExporter getDDLExporter(DDLExportFormat exportFormat) throws PortalException {
        DDLExporter exporter = _exporters.get((Object)exportFormat);
        if (exporter == null) {
            throw new PortalException("Invalid format type " + (Object)((Object)exportFormat));
        }
        return exporter;
    }

    public void setDDLExporters(Map<String, DDLExporter> exporters) {
        _exporters = new HashMap<DDLExportFormat, DDLExporter>();
        for (Map.Entry<String, DDLExporter> entry : exporters.entrySet()) {
            DDLExportFormat exportFormat = DDLExportFormat.parse(entry.getKey());
            _exporters.put(exportFormat, entry.getValue());
        }
    }
}

