/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.FieldRenderer;
import com.liferay.portlet.dynamicdatamapping.storage.FieldRendererFactory;
import java.io.Serializable;

public class Field
implements Serializable {
    private long _ddmStructureId;
    private String _name;
    private Serializable _value;

    public Field() {
    }

    public Field(long ddmStructureId, String name, Serializable value) {
        this._ddmStructureId = ddmStructureId;
        this._name = name;
        this._value = value;
    }

    public Field(String name, Serializable value) {
        this(0L, name, value);
    }

    public String getDataType() throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure();
        return ddmStructure.getFieldDataType(this._name);
    }

    public DDMStructure getDDMStructure() throws SystemException {
        return DDMStructureLocalServiceUtil.fetchStructure(this._ddmStructureId);
    }

    public long getDDMStructureId() {
        return this._ddmStructureId;
    }

    public String getName() {
        return this._name;
    }

    public String getRenderedValue(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure();
        String dataType = null;
        if (ddmStructure != null) {
            dataType = this.getDataType();
        }
        FieldRenderer fieldrenderer = FieldRendererFactory.getFieldRenderer(dataType);
        return fieldrenderer.render(themeDisplay, this);
    }

    public String getType() throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure();
        return ddmStructure.getFieldType(this._name);
    }

    public Serializable getValue() {
        return this._value;
    }

    public void setDDMStructureId(long ddmStructureId) {
        this._ddmStructureId = ddmStructureId;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(Serializable value) {
        this._value = value;
    }
}

