/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.model;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portlet.social.model.SocialAchievement;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialActivityDefinition
implements Serializable {
    private List<SocialAchievement> _achievements = new ArrayList<SocialAchievement>();
    private Map<String, SocialActivityCounterDefinition> _activityCounterDefinitions = new HashMap<String, SocialActivityCounterDefinition>();
    private SocialActivityProcessor _activityProcessor;
    private int _activityType;
    private boolean _enabled = true;
    private String _languageKey;
    private boolean _logActivity;
    private String _modelName;

    public void addCounter(SocialActivityCounterDefinition activityCounterDefinition) {
        this._activityCounterDefinitions.put(activityCounterDefinition.getName(), activityCounterDefinition);
    }

    public SocialActivityDefinition clone() {
        SocialActivityDefinition activityDefinition = new SocialActivityDefinition();
        for (SocialActivityCounterDefinition activityCounterDefinition : this._activityCounterDefinitions.values()) {
            activityDefinition.addCounter(activityCounterDefinition.clone());
        }
        List<SocialAchievement> achievements = activityDefinition.getAchievements();
        achievements.addAll(this._achievements);
        activityDefinition.setActivityProcessor(this._activityProcessor);
        activityDefinition.setActivityType(this._activityType);
        activityDefinition.setEnabled(this._enabled);
        activityDefinition.setLanguageKey(this._languageKey);
        activityDefinition.setLogActivity(this._logActivity);
        activityDefinition.setModelName(this._modelName);
        return activityDefinition;
    }

    public List<SocialAchievement> getAchievements() {
        return this._achievements;
    }

    public SocialActivityCounterDefinition getActivityCounterDefinition(String name) {
        return this._activityCounterDefinitions.get(name);
    }

    public Collection<SocialActivityCounterDefinition> getActivityCounterDefinitions() {
        return this._activityCounterDefinitions.values();
    }

    public SocialActivityProcessor getActivityProcessor() {
        return this._activityProcessor;
    }

    public int getActivityType() {
        return this._activityType;
    }

    public String getLanguageKey() {
        return this._languageKey;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getName(Locale locale) {
        return LanguageUtil.get(locale, "social.activity." + this._modelName + "." + this._languageKey);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isLogActivity() {
        return this._logActivity;
    }

    public void setActivityProcessor(SocialActivityProcessor activityProcessor) {
        this._activityProcessor = activityProcessor;
    }

    public void setActivityType(int activityKey) {
        this._activityType = activityKey;
    }

    public void setCounters(List<SocialActivityCounterDefinition> activityCounterDefinitions) {
        this._activityCounterDefinitions.clear();
        for (SocialActivityCounterDefinition activityCounterDefinition : activityCounterDefinitions) {
            this._activityCounterDefinitions.put(activityCounterDefinition.getName(), activityCounterDefinition);
        }
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setLanguageKey(String languageKey) {
        this._languageKey = languageKey;
    }

    public void setLogActivity(boolean logActivity) {
        this._logActivity = logActivity;
    }

    public void setModelName(String modelName) {
        this._modelName = modelName;
    }
}

