/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Map;

public class PortalBeanLocatorUtil {
    private static Log _log = LogFactoryUtil.getLog(PortalBeanLocatorUtil.class);
    private static BeanLocator _beanLocator;

    public static BeanLocator getBeanLocator() {
        PortalRuntimePermission.checkGetBeanProperty(PortalBeanLocatorUtil.class);
        return _beanLocator;
    }

    public static <T> Map<String, T> locate(Class<T> clazz) {
        BeanLocator beanLocator = PortalBeanLocatorUtil.getBeanLocator();
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator has not been set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader beanClassLoader = beanLocator.getClassLoader();
        try {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(beanClassLoader);
            }
            Map<String, T> map = beanLocator.locate(clazz);
            return map;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public static Object locate(String name) throws BeanLocatorException {
        BeanLocator beanLocator = PortalBeanLocatorUtil.getBeanLocator();
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            Thread.dumpStack();
            if (_log.isDebugEnabled()) {
                Exception e = new Exception();
                _log.debug(e, e);
            }
            throw new BeanLocatorException("BeanLocator has not been set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader beanClassLoader = beanLocator.getClassLoader();
        try {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(beanClassLoader);
            }
            Object object = beanLocator.locate(name);
            return object;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public static void reset() {
        PortalBeanLocatorUtil.setBeanLocator(null);
    }

    public static void setBeanLocator(BeanLocator beanLocator) {
        PortalRuntimePermission.checkSetBeanProperty(PortalBeanLocatorUtil.class);
        if (_log.isDebugEnabled()) {
            if (beanLocator == null) {
                _log.debug("Setting BeanLocator " + beanLocator);
            } else {
                _log.debug("Setting BeanLocator " + beanLocator.hashCode());
            }
        }
        _beanLocator = beanLocator;
    }
}

