/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bi.reporting;

import com.liferay.portal.kernel.bi.reporting.ReportFormat;
import com.liferay.portal.kernel.bi.reporting.ReportFormatExporter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReportFormatExporterRegistry {
    private Map<ReportFormat, ReportFormatExporter> _reportFormatExporters = new ConcurrentHashMap<ReportFormat, ReportFormatExporter>();

    public ReportFormatExporter getReportFormatExporter(ReportFormat reportFormat) {
        ReportFormatExporter reportFormatExporter = this._reportFormatExporters.get((Object)reportFormat);
        if (reportFormatExporter == null) {
            throw new IllegalArgumentException("No report format exporter found for " + (Object)((Object)reportFormat));
        }
        return reportFormatExporter;
    }

    public void setReportFormatExporters(Map<String, ReportFormatExporter> reportFormatExporters) {
        for (Map.Entry<String, ReportFormatExporter> entry : reportFormatExporters.entrySet()) {
            ReportFormat reportFormat = ReportFormat.parse(entry.getKey());
            ReportFormatExporter reportFormatExporter = entry.getValue();
            this._reportFormatExporters.put(reportFormat, reportFormatExporter);
        }
    }
}

