/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class TaskQueue<E> {
    private final int _capacity;
    private final AtomicInteger _count = new AtomicInteger();
    private Node<E> _headNode;
    private final Condition _notEmptyCondition;
    private final ReentrantLock _putLock = new ReentrantLock();
    private Node<E> _tailNode;
    private final ReentrantLock _takeLock = new ReentrantLock();

    public TaskQueue() {
        this(Integer.MAX_VALUE);
    }

    public TaskQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this._capacity = capacity;
        this._headNode = new Node(null);
        this._tailNode = this._headNode;
        this._notEmptyCondition = this._takeLock.newCondition();
    }

    public int drainTo(Collection<E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this._takeLock.lock();
        try {
            int n;
            block9: {
                Node headNode = this._headNode;
                int size = this._count.get();
                int count = 0;
                try {
                    while (count < size) {
                        Node currentNode = headNode._nextNode;
                        collection.add(currentNode._element);
                        currentNode._element = null;
                        headNode._nextNode = null;
                        headNode = currentNode;
                        ++count;
                    }
                    n = count;
                    if (count <= 0) break block9;
                    this._headNode = headNode;
                    this._count.getAndAdd(-count);
                }
                catch (Throwable throwable) {
                    if (count > 0) {
                        this._headNode = headNode;
                        this._count.getAndAdd(-count);
                    }
                    throw throwable;
                }
            }
            return n;
        }
        finally {
            this._takeLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this._count.get() == 0;
    }

    public boolean offer(E element, boolean[] hasWaiterMarker) {
        int count;
        block14: {
            if (element == null || hasWaiterMarker == null) {
                throw new NullPointerException();
            }
            if (hasWaiterMarker.length == 0) {
                throw new IllegalArgumentException();
            }
            if (this._count.get() == this._capacity) {
                return false;
            }
            count = -1;
            this._putLock.lock();
            try {
                if (this._count.get() >= this._capacity) break block14;
                this._enqueue(element);
                count = this._count.getAndIncrement();
                this._takeLock.lock();
                try {
                    hasWaiterMarker[0] = this._takeLock.hasWaiters(this._notEmptyCondition);
                    if (!hasWaiterMarker[0] && count >= this._count.get()) {
                        hasWaiterMarker[0] = true;
                    }
                }
                finally {
                    this._takeLock.unlock();
                }
            }
            finally {
                this._putLock.unlock();
            }
        }
        if (count == 0) {
            this._takeLock.lock();
            try {
                this._notEmptyCondition.signal();
            }
            finally {
                this._takeLock.unlock();
            }
        }
        return count >= 0;
    }

    public E poll() {
        if (this._count.get() == 0) {
            return null;
        }
        E element = null;
        this._takeLock.lock();
        try {
            if (this._count.get() > 0) {
                element = this._dequeue();
                if (this._count.getAndDecrement() > 1) {
                    this._notEmptyCondition.signal();
                }
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    public E poll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        E element = null;
        long nanos = timeUnit.toNanos(timeout);
        this._takeLock.lockInterruptibly();
        try {
            while (this._count.get() == 0) {
                if (nanos <= 0L) {
                    return null;
                }
                nanos = this._notEmptyCondition.awaitNanos(nanos);
            }
            element = this._dequeue();
            if (this._count.getAndDecrement() > 1) {
                this._notEmptyCondition.signal();
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    public int remainingCapacity() {
        return this._capacity - this._count.get();
    }

    public boolean remove(E element) {
        if (element == null) {
            return false;
        }
        this._fullyLock();
        try {
            Node previousNode = this._headNode;
            Node currentNode = previousNode._nextNode;
            while (currentNode != null) {
                if (element.equals(currentNode._element)) {
                    this._unlink(currentNode, previousNode);
                    return true;
                }
                previousNode = currentNode;
                currentNode = currentNode._nextNode;
            }
            return false;
        }
        finally {
            this._fullyUnlock();
        }
    }

    public int size() {
        return this._count.get();
    }

    public E take() throws InterruptedException {
        E element = null;
        this._takeLock.lockInterruptibly();
        try {
            while (this._count.get() == 0) {
                this._notEmptyCondition.await();
            }
            element = this._dequeue();
            if (this._count.getAndDecrement() > 1) {
                this._notEmptyCondition.signal();
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    protected ReentrantLock getPutLock() {
        return this._putLock;
    }

    protected ReentrantLock getTakeLock() {
        return this._takeLock;
    }

    private E _dequeue() {
        Node<E> headNode = this._headNode;
        Node firstNode = ((Node)headNode)._nextNode;
        ((Node)headNode)._nextNode = null;
        this._headNode = firstNode;
        Object element = firstNode._element;
        firstNode._element = null;
        return (E)element;
    }

    private void _enqueue(E element) {
        ((Node)this._tailNode)._nextNode = new Node(element);
        this._tailNode = ((Node)this._tailNode)._nextNode;
    }

    private void _fullyLock() {
        this._putLock.lock();
        this._takeLock.lock();
    }

    private void _fullyUnlock() {
        this._takeLock.unlock();
        this._putLock.unlock();
    }

    private void _unlink(Node<E> currentNode, Node<E> previousNode) {
        ((Node)currentNode)._element = null;
        ((Node)previousNode)._nextNode = ((Node)currentNode)._nextNode;
        if (this._tailNode == currentNode) {
            this._tailNode = previousNode;
        }
        this._count.getAndDecrement();
    }

    private static class Node<E> {
        private E _element;
        private Node<E> _nextNode;

        private Node(E element) {
            this._element = element;
        }
    }
}

