/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import java.io.Serializable;

public class FinderPath {
    private static final String _ARGS_SEPARATOR = "_A_";
    private static final String _PARAMS_SEPARATOR = "_P_";
    private CacheKeyGenerator _cacheKeyGenerator;
    private String _cacheKeyGeneratorCacheName;
    private String _cacheKeyPrefix;
    private String _cacheName;
    private long _columnBitmask;
    private boolean _entityCacheEnabled;
    private boolean _finderCacheEnabled;
    private String _localCacheKeyPrefix;
    private Class<?> _resultClass;

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, Class<?> resultClass, String cacheName, String methodName, String[] params) {
        this(entityCacheEnabled, finderCacheEnabled, resultClass, cacheName, methodName, params, -1L);
    }

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, Class<?> resultClass, String cacheName, String methodName, String[] params, long columnBitmask) {
        this._entityCacheEnabled = entityCacheEnabled;
        this._finderCacheEnabled = finderCacheEnabled;
        this._resultClass = resultClass;
        this._cacheName = cacheName;
        this._columnBitmask = columnBitmask;
        this._cacheKeyGeneratorCacheName = BaseModel.class.isAssignableFrom(this._resultClass) ? String.valueOf(FinderCache.class.getName()) + "#BaseModel" : FinderCache.class.getName();
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(this._cacheKeyGeneratorCacheName);
        if (cacheKeyGenerator.isCallingGetCacheKeyThreadSafe()) {
            this._cacheKeyGenerator = cacheKeyGenerator;
        }
        this._initCacheKeyPrefix(methodName, params);
        this._initLocalCacheKeyPrefix();
    }

    public Serializable encodeCacheKey(Object[] arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 + 3);
        sb.append(ShardUtil.getCurrentShardName());
        sb.append(".");
        sb.append(this._cacheKeyPrefix);
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(".");
            sb.append(StringUtil.toHexString(arg));
            ++n2;
        }
        return this._getCacheKey(sb);
    }

    public Serializable encodeLocalCacheKey(Object[] arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 + 3);
        sb.append(ShardUtil.getCurrentShardName());
        sb.append(".");
        sb.append(this._localCacheKeyPrefix);
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(".");
            sb.append(StringUtil.toHexString(arg));
            ++n2;
        }
        return this._getCacheKey(sb);
    }

    public String getCacheName() {
        return this._cacheName;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public Class<?> getResultClass() {
        return this._resultClass;
    }

    public boolean isEntityCacheEnabled() {
        return this._entityCacheEnabled;
    }

    public boolean isFinderCacheEnabled() {
        return this._finderCacheEnabled;
    }

    public void setCacheKeyGeneratorCacheName(String cacheKeyGeneratorCacheName) {
        if (cacheKeyGeneratorCacheName == null) {
            cacheKeyGeneratorCacheName = FinderCache.class.getName();
        }
        this._cacheKeyGeneratorCacheName = cacheKeyGeneratorCacheName;
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(cacheKeyGeneratorCacheName);
        this._cacheKeyGenerator = cacheKeyGenerator.isCallingGetCacheKeyThreadSafe() ? cacheKeyGenerator : null;
    }

    private Serializable _getCacheKey(StringBundler sb) {
        CacheKeyGenerator cacheKeyGenerator = this._cacheKeyGenerator;
        if (cacheKeyGenerator == null) {
            cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(this._cacheKeyGeneratorCacheName);
        }
        return cacheKeyGenerator.getCacheKey(sb);
    }

    private void _initCacheKeyPrefix(String methodName, String[] params) {
        StringBundler sb = new StringBundler(params.length * 2 + 3);
        sb.append(methodName);
        sb.append(_PARAMS_SEPARATOR);
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            sb.append(".");
            sb.append(param);
            ++n2;
        }
        sb.append(_ARGS_SEPARATOR);
        this._cacheKeyPrefix = sb.toString();
    }

    private void _initLocalCacheKeyPrefix() {
        this._localCacheKeyPrefix = this._cacheName.concat(".").concat(this._cacheKeyPrefix);
    }
}

